/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.intercom.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Reaction;
import java.util.ArrayList;
import java.util.List;

public class ReactionReply
implements Parcelable {
    private final List<Reaction> reactionSet;
    @Nullable
    private Integer reactionIndex;
    public static final ReactionReply NULL = new ReactionReply(new Builder());
    public static final Parcelable.Creator<ReactionReply> CREATOR = new Parcelable.Creator<ReactionReply>(){

        public ReactionReply createFromParcel(Parcel in) {
            return new ReactionReply(in);
        }

        public ReactionReply[] newArray(int size) {
            return new ReactionReply[size];
        }
    };

    ReactionReply(Builder builder) {
        this.reactionIndex = builder.reaction_index;
        this.reactionSet = new ArrayList<Reaction>(CollectionUtils.capacityFor(builder.reaction_set));
        if (builder.reaction_set != null) {
            for (Reaction.Builder reactionBuilder : builder.reaction_set) {
                this.reactionSet.add(reactionBuilder.build());
            }
        }
    }

    public List<Reaction> getReactionSet() {
        return this.reactionSet;
    }

    public void setReactionIndex(int selectedReaction) {
        this.reactionIndex = selectedReaction;
    }

    @Nullable
    public Integer getReactionIndex() {
        return this.reactionIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactionReply that = (ReactionReply)o;
        if (!this.reactionSet.equals(that.reactionSet)) {
            return false;
        }
        return this.reactionIndex != null ? this.reactionIndex.equals(that.reactionIndex) : that.reactionIndex == null;
    }

    public int hashCode() {
        int result = this.reactionSet.hashCode();
        result = 31 * result + (this.reactionIndex != null ? this.reactionIndex.hashCode() : 0);
        return result;
    }

    public static boolean isNull(ReactionReply reply) {
        return NULL.equals(reply) || reply == null;
    }

    ReactionReply(Parcel in) {
        this.reactionIndex = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.reactionSet = new ArrayList<Reaction>();
        in.readList(this.reactionSet, Reaction.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.reactionIndex == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.reactionIndex.intValue());
        }
        dest.writeList(this.reactionSet);
    }

    public static class Builder {
        Integer reaction_index;
        List<Reaction.Builder> reaction_set;

        public ReactionReply build() {
            return new ReactionReply(this);
        }
    }
}

