/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.HomeCard;
import io.intercom.android.sdk.models.HomeErrorRow;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class HomePresenter {
    private static final int CONTENT_OFFSET_DP = 64;
    private static final int CONVERSATION_CARD_POSITION = 0;
    private static final long THREE_DAYS_MILLISECONDS = 259200000L;
    private final Store<State> store;
    private final Provider<AppConfig> appConfigProvider;
    private final TimeProvider timeProvider;
    private final List<Object> cardList;
    private boolean hasOlderConversations = false;
    private final Listener listener;
    private final MetricTracker metricTracker;

    public HomePresenter(Store<State> store, Provider<AppConfig> appConfigProvider, List<Object> cardList, Listener listener, MetricTracker metricTracker) {
        this(store, appConfigProvider, TimeProvider.SYSTEM, cardList, listener, metricTracker);
    }

    @VisibleForTesting
    HomePresenter(Store<State> store, Provider<AppConfig> appConfigProvider, TimeProvider timeProvider, List<Object> cardList, Listener listener, MetricTracker metricTracker) {
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.timeProvider = timeProvider;
        this.cardList = cardList;
        this.listener = listener;
        this.metricTracker = metricTracker;
    }

    public void addLoadingCards() {
        if (this.inboundMessagesEnabled()) {
            this.cardList.add(ConversationCard.builder().isLoading(true).build());
        }
        int count = this.appConfigProvider.get().getHomeScreenCardCount();
        for (int index = 1; index <= count; ++index) {
            this.cardList.add(new HomeCard());
        }
    }

    public void clearCards() {
        this.cardList.clear();
    }

    public void updateConversationCard(boolean hasMoreConversations) {
        ConversationCard conversationCard = this.buildConversationCard(hasMoreConversations, this.inboundMessagesEnabled());
        if (conversationCard == null) {
            if (this.cardList.size() > 0) {
                Object card = this.cardList.get(0);
                if (card instanceof ConversationCard) {
                    this.cardList.remove(card);
                }
                this.listener.notifyDataSetChanged();
            }
            return;
        }
        if (this.hasConversationCard()) {
            this.cardList.set(0, conversationCard);
        } else {
            this.cardList.add(0, conversationCard);
        }
        this.listener.notifyItemChanged(0);
    }

    public void updateConversationCard() {
        this.updateConversationCard(this.hasOlderConversations);
    }

    public void addErrorRow() {
        this.cardList.add(HomeErrorRow.create());
    }

    private boolean inboundMessagesEnabled() {
        return this.appConfigProvider.get().isInboundMessages();
    }

    @Nullable
    private ConversationCard buildConversationCard(boolean hasMoreConversations, boolean hasInboundMessage) {
        this.hasOlderConversations = hasMoreConversations;
        boolean hasConversations = !this.store.state().inboxState().conversations().isEmpty();
        boolean teammateEnabled = this.appConfigProvider.get().isAccessToTeammateEnabled();
        if (!hasInboundMessage && !hasConversations) {
            return null;
        }
        List<Conversation> recentConversations = this.getRecentConversations();
        boolean hasOlderUnreadConversations = this.hasOlderUnreadConversations(recentConversations);
        return ConversationCard.builder().recentConversations(recentConversations).hasOlderConversations(this.hasOlderConversations).isTeammateEnabled(teammateEnabled).hasOlderUnreadConversations(hasOlderUnreadConversations).build();
    }

    public void updateCards(List<HomeCard> cards) {
        boolean hasConversationCard = this.hasConversationCard();
        for (int index = 0; index < cards.size(); ++index) {
            int cardPosition = hasConversationCard ? index + 1 : index;
            HomeCard homeCard = cards.get(index);
            if (cardPosition < this.cardList.size()) {
                this.cardList.set(cardPosition, homeCard);
            } else {
                this.cardList.add(cardPosition, homeCard);
            }
            if ("help_center".equals(homeCard.getSlotType())) {
                this.metricTracker.viewedSearchBrowseCard(cardPosition);
            }
            this.listener.notifyItemChanged(cardPosition);
        }
    }

    private boolean hasConversationCard() {
        return !this.cardList.isEmpty() && this.cardList.get(0) instanceof ConversationCard;
    }

    @VisibleForTesting
    List<Conversation> getRecentConversations() {
        ArrayList<Conversation> recentConversations = new ArrayList<Conversation>();
        long threeDaysAgo = this.timeProvider.currentTimeMillis() - 259200000L;
        List<Conversation> conversations = this.store.state().inboxState().conversations();
        for (Conversation conversation : conversations) {
            long lastUpdateAt = conversation.getLastPart().getCreatedAt() * 1000L;
            if (lastUpdateAt < threeDaysAgo) {
                this.hasOlderConversations = true;
                break;
            }
            recentConversations.add(conversation);
        }
        if (recentConversations.size() > 3) {
            this.hasOlderConversations = true;
        }
        return recentConversations;
    }

    @VisibleForTesting
    boolean hasOlderUnreadConversations(List<Conversation> recentConversations) {
        HashSet<String> unreadConversationIds = new HashSet<String>(this.store.state().unreadConversationIds());
        for (Conversation conversation : recentConversations) {
            String conversationId = conversation.getId();
            if (!unreadConversationIds.contains(conversation.getId())) continue;
            unreadConversationIds.remove(conversationId);
        }
        return !unreadConversationIds.isEmpty();
    }

    public void renderHeaderScrollChange(RecyclerView cardList, int startLocationY, View closeBackground, View toolbarContent) {
        View firstCard = cardList.getChildAt(0);
        if (firstCard != null) {
            int[] firstCardLocation = new int[2];
            firstCard.getLocationInWindow(firstCardLocation);
            int currentLocationY = firstCardLocation[1];
            float scrollPercentAsDecimal = this.clamp((float)currentLocationY * 100.0f / (float)startLocationY) / 100.0f;
            closeBackground.setAlpha(this.inverseDecimalPercentage(scrollPercentAsDecimal));
            toolbarContent.setAlpha(scrollPercentAsDecimal);
            toolbarContent.setTranslationY((float)ScreenUtils.dpToPx((float)64.0f, (Context)toolbarContent.getContext()) * -this.inverseDecimalPercentage(scrollPercentAsDecimal));
        }
    }

    private float inverseDecimalPercentage(float percent) {
        return 1.0f - percent;
    }

    private float clamp(float value) {
        return Math.min(Math.max(value, 0.0f), 100.0f);
    }

    public static interface Listener {
        public void notifyItemChanged(int var1);

        public void notifyDataSetChanged();
    }
}

