/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.databinding.IntercomArticleSearchCardBinding;
import io.intercom.android.sdk.homescreen.ArticleSearchCardViewHolder;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.homescreen.ConversationCardLoadingViewHolder;
import io.intercom.android.sdk.homescreen.ErrorViewHolder;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.MessengerAppCardViewHolder;
import io.intercom.android.sdk.homescreen.NewConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.RecentConversationCardViewHolder;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.HomeCard;
import io.intercom.android.sdk.models.HomeErrorRow;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&Bg\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001cH\u0016R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/intercom/android/sdk/homescreen/HomeCardAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "cardList", "", "", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "appConfigProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/identity/AppConfig;", "bus", "Lcom/squareup/otto/Bus;", "gson", "Lcom/google/gson/Gson;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "timeFormatter", "Lio/intercom/android/sdk/utilities/TimeFormatter;", "clickListener", "Lio/intercom/android/sdk/homescreen/HomeClickListener;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "activity", "Landroid/app/Activity;", "(Ljava/util/List;Lio/intercom/android/sdk/store/Store;Lio/intercom/android/sdk/Provider;Lcom/squareup/otto/Bus;Lcom/google/gson/Gson;Lio/intercom/android/sdk/metrics/MetricTracker;Lio/intercom/android/sdk/utilities/TimeFormatter;Lio/intercom/android/sdk/homescreen/HomeClickListener;Lio/intercom/android/sdk/identity/UserIdentity;Landroid/app/Activity;)V", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "intercom-sdk-base_release"})
public final class HomeCardAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Object> cardList;
    @NotNull
    private final Store<State> store;
    @NotNull
    private final Provider<AppConfig> appConfigProvider;
    @NotNull
    private final Bus bus;
    @NotNull
    private final Gson gson;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final TimeFormatter timeFormatter;
    @NotNull
    private final HomeClickListener clickListener;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final Activity activity;
    public static final int NEW_CONVERSATION_CARD = 0;
    public static final int RECENT_CONVERSATION_CARD = 1;
    public static final int MESSENGER_CARD = 2;
    public static final int LOADING_CONVERSATION_CARD = 3;
    public static final int ERROR_ROW = 4;
    public static final int ARTICLE_SEARCH_CARD = 5;

    public HomeCardAdapter(@NotNull List<? extends Object> cardList, @NotNull Store<State> store, @NotNull Provider<AppConfig> appConfigProvider, @NotNull Bus bus, @NotNull Gson gson, @NotNull MetricTracker metricTracker, @NotNull TimeFormatter timeFormatter, @NotNull HomeClickListener clickListener, @NotNull UserIdentity userIdentity, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter(cardList, (String)"cardList");
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter(appConfigProvider, (String)"appConfigProvider");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)timeFormatter, (String)"timeFormatter");
        Intrinsics.checkNotNullParameter((Object)clickListener, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.cardList = cardList;
        this.store = store;
        this.appConfigProvider = appConfigProvider;
        this.bus = bus;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.timeFormatter = timeFormatter;
        this.clickListener = clickListener;
        this.userIdentity = userIdentity;
        this.activity = activity;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        int n = viewType;
        switch (n) {
            case 0: {
                View view = inflater.inflate(R.layout.intercom_new_conversation_card, parent, false);
                viewHolder = new NewConversationCardViewHolder(view, this.appConfigProvider, this.clickListener);
                break;
            }
            case 1: {
                View view = inflater.inflate(R.layout.intercom_recent_conversation_card, parent, false);
                viewHolder = new RecentConversationCardViewHolder(view, this.timeFormatter, this.appConfigProvider, this.clickListener);
                break;
            }
            case 2: {
                View view = inflater.inflate(R.layout.intercom_messenger_app_card, parent, false);
                viewHolder = new MessengerAppCardViewHolder(view, this.bus, this.appConfigProvider, this.gson, this.metricTracker, this.activity);
                break;
            }
            case 4: {
                View view = inflater.inflate(R.layout.intercom_home_error_row, parent, false);
                viewHolder = new ErrorViewHolder(view, this.appConfigProvider, this.clickListener);
                break;
            }
            case 5: {
                Object object = IntercomArticleSearchCardBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.from(parent.context), parent, false)");
                IntercomArticleSearchCardBinding binding = object;
                object = this.appConfigProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appConfigProvider.get()");
                viewHolder = new ArticleSearchCardViewHolder(binding, (AppConfig)object, this.clickListener);
                break;
            }
            default: {
                View view = inflater.inflate(R.layout.intercom_row_card_loading, parent, false);
                viewHolder = new ConversationCardLoadingViewHolder(view, this.appConfigProvider);
            }
        }
        return viewHolder;
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        TeamPresence teamPresence = this.store.select(Selectors.TEAM_PRESENCE);
        Object card = this.cardList.get(position);
        if (card instanceof ConversationCard) {
            if (holder instanceof NewConversationCardViewHolder) {
                ((NewConversationCardViewHolder)holder).bindTeamPresence(teamPresence, (ConversationCard)card);
            } else if (holder instanceof RecentConversationCardViewHolder) {
                ((RecentConversationCardViewHolder)holder).bindConversationCard((ConversationCard)card, this.userIdentity, this.appConfigProvider.get(), teamPresence);
            }
        } else if (card instanceof HomeCard) {
            if (holder instanceof MessengerAppCardViewHolder) {
                ((MessengerAppCardViewHolder)holder).bindCard(((HomeCard)card).getFallbackUrl());
            } else if (holder instanceof ArticleSearchCardViewHolder) {
                ArticleSearchCardViewHolder articleSearchCardViewHolder = (ArticleSearchCardViewHolder)holder;
                Intrinsics.checkNotNullExpressionValue((Object)teamPresence, (String)"teamPresence");
                articleSearchCardViewHolder.bindTeamPresence(teamPresence);
            }
        }
    }

    public int getItemCount() {
        return this.cardList.size();
    }

    public int getItemViewType(int position) {
        Object item = this.cardList.get(position);
        if (item instanceof ConversationCard) {
            ConversationCard conversationCard = (ConversationCard)this.cardList.get(position);
            return conversationCard.isLoading() ? 3 : (conversationCard.recentConversations().isEmpty() ? 0 : 1);
        }
        if (item instanceof HomeErrorRow) {
            return 4;
        }
        if (item instanceof HomeCard && Intrinsics.areEqual((Object)((HomeCard)item).getSlotType(), (Object)"help_center")) {
            return 5;
        }
        return 2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/homescreen/HomeCardAdapter$Companion;", "", "()V", "ARTICLE_SEARCH_CARD", "", "ERROR_ROW", "LOADING_CONVERSATION_CARD", "MESSENGER_CARD", "NEW_CONVERSATION_CARD", "RECENT_CONVERSATION_CARD", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

