/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.articles;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.articles.ArticleWebViewListener;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewModel;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.helpcenter.component.TeammateHelpKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.store.Selectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bJ\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0006\u0010$\u001a\u00020\u001bJ\u0019\u0010%\u001a\u00020\u001b2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010*\u001a\u00020'H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/intercom/android/sdk/articles/ArticleWebViewListener;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "baseUrl", "", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "metricPlace", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Ljava/lang/String;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/models/TeamPresence;Lio/intercom/android/sdk/metrics/MetricTracker;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState;", "articleContentId", "articleId", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "articleContentIdFetched", "", "value", "articleNotFound", "fragmentLoaded", "happyReactionTapped", "neutralReactionTapped", "onArticleFinishedLoading", "onArticleLoadingError", "onArticleStartedLoading", "sadReactionTapped", "sendFailedMetric", "errorCode", "", "(Ljava/lang/Integer;)V", "sendReactionToServer", "reactionIndex", "Companion", "intercom-sdk-base_release"})
public final class ArticleViewModel
extends ViewModel
implements ArticleWebViewListener {
    private final MutableStateFlow<ArticleViewState> _state;
    @NotNull
    private final StateFlow<ArticleViewState> state;
    private String articleContentId;
    private String articleId;
    private final HelpCenterApi helpCenterApi;
    private final String baseUrl;
    private final AppConfig appConfig;
    private final TeamPresence teamPresence;
    private final MetricTracker metricTracker;
    private final CoroutineDispatcher dispatcher;
    public static final int HAPPY_SERVER_INDEX = 0;
    public static final int NEUTRAL_SERVER_INDEX = 1;
    public static final int SAD_SERVER_INDEX = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final StateFlow<ArticleViewState> getState() {
        return this.state;
    }

    public final void fragmentLoaded(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.articleId = articleId;
        String url = this.baseUrl + "/articles/" + articleId;
        this._state.setValue((Object)new ArticleViewState.Content(url, articleId, ArticleViewState.WebViewStatus.Idle, ArticleViewState.ReactionState.Companion.getDefaultReactionState(), ArticleViewState.TeamPresenceState.Companion.getDefaultTeamPresenceState()));
    }

    @Override
    public void onArticleFinishedLoading() {
        this.metricTracker.viewedNativeHelpCenter("article", null);
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, ArticleViewState.WebViewStatus.Ready, null, null, 27, null));
        } else if (Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) || !(currentState instanceof ArticleViewState.Error)) {
            // empty if block
        }
    }

    @Override
    public void onArticleLoadingError() {
        ArticleViewModel.sendFailedMetric$default(this, null, 1, null);
        this._state.setValue((Object)new ArticleViewState.Error(R.string.intercom_something_went_wrong_try_again, 0, this.appConfig.getPrimaryColor()));
    }

    @Override
    public void articleNotFound() {
        this.sendFailedMetric(404);
        this._state.setValue((Object)new ArticleViewState.Error(R.string.intercom_page_not_found, 8, this.appConfig.getPrimaryColor()));
    }

    @Override
    public void onArticleStartedLoading() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, ArticleViewState.WebViewStatus.Loading, null, null, 27, null));
        } else if (!Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) && !(currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sadReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$with;
            boolean bl = false;
            boolean bl2 = false;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl3 = false;
            this.metricTracker.sentArticleReaction("reaction_sad", this.appConfig.isInboundMessages());
            this.sendReactionToServer($this$with.getArticleId(), this.articleContentId, 2);
            int transitionState = R.id.sad_end;
            int teamHelpVisibility = 8;
            boolean shouldScrollToBottom = false;
            if (this.appConfig.isInboundMessages()) {
                teamHelpVisibility = 0;
                shouldScrollToBottom = true;
            }
            ArticleViewState.Content content2 = ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$with, null, null, null, ArticleViewState.ReactionState.copy$default($this$with.getReactionState(), 0, transitionState, teamHelpVisibility, shouldScrollToBottom, 1, null), TeammateHelpKt.computeViewState($this$with.getArticleId(), $this$with.getTeamPresenceState(), this.appConfig, this.teamPresence, "article"), 7, null);
            mutableStateFlow.setValue((Object)content2);
        } else if (!Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) && !(currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void happyReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$with;
            boolean bl = false;
            boolean bl2 = false;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl3 = false;
            this.metricTracker.sentArticleReaction("reaction_happy", null);
            this.sendReactionToServer($this$with.getArticleId(), this.articleContentId, 0);
            ArticleViewState.Content content2 = ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$with, null, null, null, ArticleViewState.ReactionState.copy$default($this$with.getReactionState(), 0, R.id.happy_end, 8, false, 1, null), null, 23, null);
            mutableStateFlow.setValue((Object)content2);
        } else if (!Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) && !(currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void neutralReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$with;
            boolean bl = false;
            boolean bl2 = false;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl3 = false;
            this.metricTracker.sentArticleReaction("reaction_neutral", null);
            this.sendReactionToServer($this$with.getArticleId(), this.articleContentId, 1);
            ArticleViewState.Content content2 = ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$with, null, null, null, ArticleViewState.ReactionState.copy$default($this$with.getReactionState(), 0, R.id.neutral_end, 8, false, 1, null), null, 23, null);
            mutableStateFlow.setValue((Object)content2);
        } else if (!Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) && !(currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void sendReactionToServer(String articleId, String articleContentId, int reactionIndex) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, articleId, reactionIndex, articleContentId, null){
            int label;
            final /* synthetic */ ArticleViewModel this$0;
            final /* synthetic */ String $articleId;
            final /* synthetic */ int $reactionIndex;
            final /* synthetic */ String $articleContentId;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HelpCenterApi.DefaultImpls.reactToArticle$default(ArticleViewModel.access$getHelpCenterApi$p(this.this$0), this.$articleId, this.$reactionIndex, this.$articleContentId, false, null, (Continuation)this, 24, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = articleViewModel;
                this.$articleId = string2;
                this.$reactionIndex = n;
                this.$articleContentId = string3;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void articleContentIdFetched(@Nullable String value) {
        if (value != null) {
            this.articleContentId = value;
            ArticleViewState currentState = (ArticleViewState)this._state.getValue();
            if (currentState instanceof ArticleViewState.Content) {
                this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, null, ArticleViewState.ReactionState.copy$default(((ArticleViewState.Content)currentState).getReactionState(), 0, 0, 0, false, 14, null), null, 23, null));
            } else if (Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) || !(currentState instanceof ArticleViewState.Error)) {
                // empty if block
            }
        }
    }

    private final void sendFailedMetric(Integer errorCode) {
        Integer n = errorCode;
        this.metricTracker.failedHelpCenter("help_center", "article", n != null ? String.valueOf(n) : null);
    }

    static /* synthetic */ void sendFailedMetric$default(ArticleViewModel articleViewModel, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        articleViewModel.sendFailedMetric(n);
    }

    public ArticleViewModel(@NotNull HelpCenterApi helpCenterApi, @NotNull String baseUrl, @NotNull AppConfig appConfig, @NotNull TeamPresence teamPresence, @NotNull MetricTracker metricTracker, @NotNull String metricPlace, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.helpCenterApi = helpCenterApi;
        this.baseUrl = baseUrl;
        this.appConfig = appConfig;
        this.teamPresence = teamPresence;
        this.metricTracker = metricTracker;
        this.dispatcher = dispatcher;
        this._state = StateFlowKt.MutableStateFlow((Object)ArticleViewState.Initial.INSTANCE);
        this.state = FlowKt.asStateFlow(this._state);
        this.articleContentId = "";
        this.articleId = "";
        if (Intrinsics.areEqual((Object)metricPlace, (Object)"collection_list") ^ true && Intrinsics.areEqual((Object)metricPlace, (Object)"article") ^ true) {
            String metricContext = "no_context";
            if (Intrinsics.areEqual((Object)metricPlace, (Object)"api")) {
                metricContext = "article";
            }
            this.metricTracker.openedNativeHelpCenter(metricPlace, metricContext);
        }
    }

    public /* synthetic */ ArticleViewModel(HelpCenterApi helpCenterApi, String string2, AppConfig appConfig, TeamPresence teamPresence, MetricTracker metricTracker, String string3, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(helpCenterApi, string2, appConfig, teamPresence, metricTracker, string3, coroutineDispatcher);
    }

    public static final /* synthetic */ HelpCenterApi access$getHelpCenterApi$p(ArticleViewModel $this) {
        return $this.helpCenterApi;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion;", "", "()V", "HAPPY_SERVER_INDEX", "", "NEUTRAL_SERVER_INDEX", "SAD_SERVER_INDEX", "create", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "baseUrl", "", "metricPlace", "factory", "io/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion$factory$1", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Ljava/lang/String;Ljava/lang/String;)Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        @NotNull
        public final ArticleViewModel create(@NotNull ViewModelStoreOwner owner, @NotNull HelpCenterApi helpCenterApi, @NotNull String baseUrl, @NotNull String metricPlace) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
            ViewModel viewModel2 = new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory(helpCenterApi, baseUrl, metricPlace)).get(ArticleViewModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"ViewModelProvider(\n     \u2026cleViewModel::class.java)");
            return (ArticleViewModel)viewModel2;
        }

        private final factory.1 factory(HelpCenterApi helpCenterApi, String baseUrl, String metricPlace) {
            return new ViewModelProvider.Factory(helpCenterApi, baseUrl, metricPlace){
                final /* synthetic */ HelpCenterApi $helpCenterApi;
                final /* synthetic */ String $baseUrl;
                final /* synthetic */ String $metricPlace;

                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    Injector injector = Injector.get();
                    Intrinsics.checkNotNullExpressionValue((Object)injector, (String)"Injector.get()");
                    AppConfig appConfig = injector.getAppConfigProvider().get();
                    Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"Injector.get().appConfigProvider.get()");
                    Injector injector2 = Injector.get();
                    Intrinsics.checkNotNullExpressionValue((Object)injector2, (String)"Injector.get()");
                    TeamPresence teamPresence = injector2.getStore().select(Selectors.TEAM_PRESENCE);
                    Intrinsics.checkNotNullExpressionValue((Object)teamPresence, (String)"Injector.get().store.sel\u2026(Selectors.TEAM_PRESENCE)");
                    Injector injector3 = Injector.get();
                    Intrinsics.checkNotNullExpressionValue((Object)injector3, (String)"Injector.get()");
                    MetricTracker metricTracker = injector3.getMetricTracker();
                    Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"Injector.get().metricTracker");
                    return (T)new ArticleViewModel(this.$helpCenterApi, this.$baseUrl, appConfig, teamPresence, metricTracker, this.$metricPlace, null, 64, null);
                }
                {
                    this.$helpCenterApi = $captured_local_variable$0;
                    this.$baseUrl = $captured_local_variable$1;
                    this.$metricPlace = $captured_local_variable$2;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

