/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.LruCache;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.android.sdk.nexus.NexusSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

@TargetApi(value=14)
public class NexusClient
implements NexusListener {
    private final LruCache<String, Boolean> cache = new LruCache(100);
    private final List<NexusListener> listeners = new CopyOnWriteArrayList<NexusListener>();
    private final List<NexusSocket> sockets = new ArrayList<NexusSocket>();
    private long presenceInterval;
    private Handler backgroundHandler;

    public NexusClient() {
        HandlerThread bgThread = new HandlerThread("background-handler");
        bgThread.start();
        this.backgroundHandler = new Handler(bgThread.getLooper());
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            NexusLogger.errorLog("No endpoints present");
        }
        for (String url : config.getEndpoints()) {
            this.sockets.add(new NexusSocket(url, config.getConnectionTimeout(), shouldSendPresence, this));
            NexusLogger.log("adding socket");
        }
        this.presenceInterval = TimeUnit.SECONDS.toMillis(config.getPresenceHeartbeatInterval());
        if (shouldSendPresence) {
            this.schedulePresence();
        }
    }

    public synchronized void disconnect() {
        if (!this.sockets.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.disconnect();
                NexusLogger.log("disconnecting socket");
            }
            this.sockets.clear();
            NexusLogger.log("client disconnected");
        }
        this.backgroundHandler.removeCallbacksAndMessages(null);
    }

    public synchronized void fire(NexusEvent event) {
        this.cache.put((Object)event.getGuid(), (Object)true);
        String data = event.toJsonFormattedString();
        if (!data.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.fire(data);
            }
        }
    }

    public synchronized boolean isConnected() {
        for (NexusSocket socket : this.sockets) {
            if (!socket.isConnected()) continue;
            return true;
        }
        return false;
    }

    public void addEventListener(NexusListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(NexusListener listener) {
        this.listeners.remove(listener);
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        NexusLogger.setLoggingEnabled(loggingEnabled);
    }

    public void setPresenceHeartbeatEnabled(boolean presenceHeartbeatEnabled) {
        this.backgroundHandler.removeCallbacksAndMessages(null);
        if (presenceHeartbeatEnabled) {
            this.schedulePresence();
        }
    }

    private void schedulePresence() {
        if (this.presenceInterval > 0L) {
            this.backgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    NexusClient.this.fire(NexusEvent.UserPresence);
                    NexusClient.this.schedulePresence();
                }
            }, this.presenceInterval);
        }
    }

    @Override
    public void notifyEvent(NexusEvent event) {
        if (event != NexusEvent.UNKNOWN && this.cache.get((Object)event.getGuid()) == null) {
            this.cache.put((Object)event.getGuid(), (Object)true);
            NexusLogger.log("notifying a listener");
            for (NexusListener listener : this.listeners) {
                listener.notifyEvent(event);
            }
        }
    }

    @Override
    public void onConnect() {
        NexusLogger.log("notifying listeners that a connection opened");
        for (NexusListener listener : this.listeners) {
            listener.onConnect();
        }
    }

    @Override
    public void onConnectFailed() {
        NexusLogger.log("notifying listeners that a connection failed to open");
        for (NexusListener listener : this.listeners) {
            listener.onConnectFailed();
        }
    }
}

