/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.logger.Logger;
import java.util.Locale;

public class LinkUtil {
    public static void openUrl(String trackingUrl, Context context) {
        Uri uri = Uri.parse((String)trackingUrl);
        if (uri.getScheme() != null && (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https"))) {
            Bridge.getApi().hitTrackingUrl(trackingUrl);
        } else {
            Logger.INTERNAL("Tracking Error", "Tracking url requires a http or https scheme");
        }
        Uri targetUri = LinkUtil.getTargetUriFromTrackingUrl(trackingUrl);
        Intent intent = "mailto".equals(targetUri.getScheme()) ? new Intent("android.intent.action.SENDTO", targetUri) : new Intent("android.intent.action.VIEW", targetUri);
        try {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Logger.ERROR("No activity found to handle that link");
        }
    }

    public static Uri getTargetUriFromTrackingUrl(String trackingUrl) {
        Uri uri = Uri.parse((String)trackingUrl);
        String queryUrl = uri.isHierarchical() ? uri.getQueryParameter("url") : trackingUrl;
        String targetUrl = queryUrl == null ? trackingUrl : queryUrl;
        uri = Uri.parse((String)targetUrl);
        if (uri.getScheme() == null) {
            uri = Uri.parse((String)("http://" + targetUrl));
        }
        if (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            uri = LinkUtil.normalizeScheme(uri);
        }
        return uri;
    }

    private static Uri normalizeScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return uri;
        }
        String lowerScheme = scheme.toLowerCase(Locale.ROOT);
        if (scheme.equals(lowerScheme)) {
            return uri;
        }
        return uri.buildUpon().scheme(lowerScheme).build();
    }
}

