/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.Inbox;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Inbox.ConversationsHolder;
import io.intercom.android.sdk.Inbox.ConversationsListAdapter;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.interfaces.OnConversationClickListener;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationList;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.models.Events.ConversationEvent;
import io.intercom.android.sdk.models.Events.ConversationsListDataChanged;
import io.intercom.android.sdk.models.Events.Failure.InboxFailedEvent;
import io.intercom.android.sdk.models.Events.InboxEvent;
import io.intercom.android.sdk.models.Events.NewConversationEvent;
import io.intercom.android.sdk.models.Events.ReadEvent;
import io.intercom.android.sdk.models.Events.ReplyEvent;
import io.intercom.android.sdk.models.Events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.com.squareup.otto.Subscribe;

@TargetApi(value=15)
public class ConversationsListFragment
extends Fragment
implements View.OnClickListener,
AdapterView.OnItemClickListener,
AbsListView.OnScrollListener {
    private static final int INBOX_PAGE_SIZE = 10;
    protected ConversationsHolder conversationsHolder;
    private View rootView;
    private ListView inboxView;
    private LinearLayout errorView;
    private LinearLayout emptyView;
    private LinearLayout loadingView;
    private Button retryButton;
    private ImageButton composerButton;
    private OnConversationClickListener conversationClickListener;
    private ConversationsListAdapter conversationsListAdapter;
    private String openConversationId = "";
    private int unreadCount;
    private boolean loading;

    public static ConversationsListFragment getInstance() {
        return new ConversationsListFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bridge.init(this.getActivity().getApplicationContext());
        this.loading = true;
        this.conversationsHolder = new ConversationsHolder();
        this.conversationsListAdapter = new ConversationsListAdapter((Context)this.getActivity(), R.layout.intercomsdk_inbox_row, this.conversationsHolder);
        Bridge.getBus().register((Object)this);
        this.fetchNewConversations();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Logger.INTERNAL("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercomsdk_fragment_inbox, container, false);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.openConversationId = "";
        this.loadingView = (LinearLayout)this.rootView.findViewById(R.id.loading_layout);
        this.errorView = (LinearLayout)this.rootView.findViewById(R.id.error_layout);
        this.emptyView = (LinearLayout)this.rootView.findViewById(R.id.empty_layout);
        this.inboxView = (ListView)this.rootView.findViewById(R.id.listView);
        this.retryButton = (Button)this.rootView.findViewById(R.id.retry_button);
        this.composerButton = (ImageButton)this.rootView.findViewById(R.id.compose_button);
        ImageButton closeButton = (ImageButton)this.rootView.findViewById(R.id.close_button);
        FontUtils.setTypeface((TextView)this.retryButton, "intercomsdk_roboto_medium.ttf", (Context)this.getActivity());
        FontUtils.setTypeface((TextView)this.rootView.findViewById(R.id.appTitleText), "intercomsdk_roboto_medium.ttf", (Context)this.getActivity());
        this.composerButton.setOnClickListener((View.OnClickListener)this);
        closeButton.setOnClickListener((View.OnClickListener)this);
        this.retryButton.setOnClickListener((View.OnClickListener)this);
        this.inboxView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.inboxView.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.inboxView.setAdapter((ListAdapter)this.conversationsListAdapter);
        this.conversationsListAdapter.notifyDataSetChanged();
        this.enableComposerButton(true);
        if (this.conversationsHolder.isEmpty()) {
            this.displayLoadingView();
        } else {
            this.displayInbox();
        }
        return this.rootView;
    }

    public void onStart() {
        super.onStart();
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        Bridge.getBus().unregister((Object)this);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.close_button) {
            Bridge.getBus().post((Object)new CloseIAMEvent());
        } else if (id2 == R.id.compose_button) {
            this.conversationClickListener.loadConversation("", this.unreadCount, true);
        } else if (id2 == R.id.retry_button) {
            this.displayLoadingView();
            this.fetchNewConversations();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Conversation conversation = (Conversation)this.conversationsHolder.get(position);
        this.conversationClickListener.loadConversation(conversation.getId(), this.unreadCount, conversation.getRead());
        this.openConversationId = conversation.getId();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.conversationClickListener = (OnConversationClickListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity + " must implement OnConversationClickListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.conversationClickListener = null;
    }

    private void enableComposerButton(boolean enable) {
        if (Bridge.getIdentityStore().getAppConfig().isInboundMessages() && enable) {
            this.composerButton.setVisibility(0);
        } else {
            this.composerButton.setVisibility(8);
        }
    }

    private void displayInbox() {
        if (this.isAdded()) {
            this.errorView.setVisibility(8);
            this.inboxView.setVisibility(0);
            this.emptyView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayError() {
        if (this.isAdded()) {
            this.errorView.setVisibility(0);
            this.inboxView.setVisibility(8);
            this.emptyView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayEmptyView() {
        if (this.isAdded()) {
            ((TextView)this.emptyView.findViewById(R.id.empty_text)).setText((CharSequence)this.getResources().getString(R.string.intercomsdk_empty_conversations));
            this.errorView.setVisibility(8);
            this.inboxView.setVisibility(8);
            this.emptyView.setVisibility(0);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayLoadingView() {
        if (this.isAdded()) {
            this.errorView.setVisibility(8);
            this.inboxView.setVisibility(8);
            this.emptyView.setVisibility(8);
            this.loadingView.setVisibility(0);
            ((ProgressBar)this.loadingView.findViewById(R.id.progressBar)).getIndeterminateDrawable().setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()), PorterDuff.Mode.SRC_IN);
        }
    }

    private void displayAsSessionError() {
        this.retryButton.setVisibility(8);
        this.enableComposerButton(false);
        this.displayError();
    }

    private void addLoadingCell() {
        Conversation.Loading loadingCell = new Conversation.Loading();
        this.conversationsHolder.add(loadingCell);
        this.conversationsListAdapter.notifyDataSetChanged();
    }

    private void removeLoadingCell() {
        int numConversations = this.conversationsHolder.size();
        if (numConversations > 0 && this.conversationsHolder.get(numConversations - 1) instanceof Conversation.Loading) {
            this.conversationsHolder.remove(numConversations - 1);
            this.conversationsListAdapter.notifyDataSetChanged();
        }
    }

    private void fetchNewConversations() {
        Bridge.getApi().getInbox();
        Bridge.getPoller().resetInboxPoll();
    }

    private void realtimeUpdate() {
        if (Bridge.getIdentityStore().getAppConfig().isRealTime()) {
            this.fetchNewConversations();
        } else {
            Bridge.getPoller().throttledInboxPoll();
        }
    }

    @Subscribe
    public void inboxSuccess(InboxEvent event) {
        ConversationList list = event.getResponse();
        this.unreadCount = list.getTotalUnreadCount();
        this.removeLoadingCell();
        this.conversationsHolder.syncInbox(list);
        if (this.isAdded()) {
            if (list.getConversations().isEmpty() && this.conversationsHolder.isEmpty()) {
                this.displayEmptyView();
            } else {
                this.displayInbox();
            }
            if (list.getConversations().size() >= 10) {
                this.loading = false;
            }
            this.enableComposerButton(true);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.loading && totalItemCount >= firstVisibleItem && totalItemCount <= firstVisibleItem + visibleItemCount && visibleItemCount > 1 && totalItemCount >= 10) {
            Conversation conversation = (Conversation)this.conversationsHolder.get(this.conversationsHolder.size() - 1);
            Bridge.getApi().getInboxBefore(conversation.getLastPart().getCreatedAt());
            this.addLoadingCell();
            this.loading = true;
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    private void markConversationAsRead(String conversationId) {
        if (conversationId == null) {
            return;
        }
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            Conversation conversation = (Conversation)this.conversationsHolder.get(i);
            if (!conversation.getId().equals(conversationId)) continue;
            conversation.setRead(true);
            break;
        }
        this.conditionallyNotifyDataSetChanged();
    }

    @Subscribe
    public void inboxFailedToLoad(InboxFailedEvent event) {
        if (this.isAdded()) {
            this.displayError();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (!event.getConversationId().equals(this.openConversationId)) {
            this.realtimeUpdate();
        }
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void markedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversationsHolder) {
            if (!conversation.getId().equals(event.getConversationId())) continue;
            conversation.setRead(true);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void newConversationEvent(NewConversationEvent event) {
        Conversation newConversation = event.getResponse();
        if (!this.conversationsHolder.contains(newConversation)) {
            this.conversationsHolder.add(0, newConversation);
            this.conditionallyNotifyDataSetChanged();
        }
    }

    @Subscribe
    public void conversationRefresh(ConversationEvent event) {
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            if (!((Conversation)this.conversationsHolder.get(i)).getId().equals(event.getResponse().getId())) continue;
            this.conversationsHolder.remove(i);
            this.conversationsHolder.add(i, event.getResponse());
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void replyInConversation(ReplyEvent event) {
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            if (!((Conversation)this.conversationsHolder.get(i)).getId().equals(event.getConversationId())) continue;
            Conversation conversation = (Conversation)this.conversationsHolder.remove(i);
            conversation.getParts().add(event.getResponse());
            this.conversationsHolder.add(0, conversation);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void dataSetChanged(ConversationsListDataChanged event) {
        this.conditionallyNotifyDataSetChanged();
    }

    private void conditionallyNotifyDataSetChanged() {
        if (this.isAdded()) {
            this.conversationsListAdapter.notifyDataSetChanged();
        }
    }
}

