/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import io.intercom.android.blocks.BlocksViewHolder;
import io.intercom.android.blocks.blockInterfaces.AttachmentListBlock;
import io.intercom.android.blocks.blockInterfaces.ButtonBlock;
import io.intercom.android.blocks.blockInterfaces.CodeBlock;
import io.intercom.android.blocks.blockInterfaces.FacebookBlock;
import io.intercom.android.blocks.blockInterfaces.HeadingBlock;
import io.intercom.android.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.blocks.blockInterfaces.LightWeightReplyBlock;
import io.intercom.android.blocks.blockInterfaces.LocalAttachmentBlock;
import io.intercom.android.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.android.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.android.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.android.blocks.blockInterfaces.TwitterBlock;
import io.intercom.android.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.android.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.Facebook;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.LightWeightReply;
import io.intercom.android.sdk.blocks.LocalAttachment;
import io.intercom.android.sdk.blocks.LocalImage;
import io.intercom.android.sdk.blocks.NetworkImage;
import io.intercom.android.sdk.blocks.OrderedList;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.Subheading;
import io.intercom.android.sdk.blocks.Twitter;
import io.intercom.android.sdk.blocks.UnorderedList;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.interfaces.LWRListener;

public class ViewHolderGenerator {
    private final Context context;

    public ViewHolderGenerator(Context context) {
        this.context = context;
    }

    public BlocksViewHolder getAdminHolder(LWRListener listener) {
        return this.generateHolder(R.layout.intercomsdk_blocks_admin_layout, StyleType.ADMIN, listener);
    }

    public BlocksViewHolder getAnnouncementLWRHolder(LWRListener listener) {
        return this.generateHolder(R.layout.intercomsdk_blocks_announcement_lwr_layout, StyleType.ANNOUNCEMENT, listener);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_user_layout, StyleType.USER);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_user_layout, StyleType.PREVIEW);
    }

    public BlocksViewHolder getAnnouncementHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_announcement_layout, StyleType.ANNOUNCEMENT);
    }

    public BlocksViewHolder getAnnouncementPreviewHolder(LWRListener listener) {
        return this.generateHolder(R.layout.intercomsdk_blocks_announcement_preview_layout, StyleType.ANNOUNCEMENT, listener);
    }

    public BlocksViewHolder getWelcomeHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_welcome_layout, StyleType.WELCOME);
    }

    private BlocksViewHolder generateHolder(int layoutId, StyleType style) {
        return this.generateHolder(layoutId, style, null);
    }

    private BlocksViewHolder generateHolder(int layoutId, StyleType style, LWRListener listener) {
        BlocksViewHolder holder = new BlocksViewHolder();
        holder.setLayout(layoutId);
        holder.setParagraph((ParagraphBlock)new Paragraph(this.context, style));
        holder.setHeading((HeadingBlock)new Heading(this.context, style));
        holder.setSubheading((SubheadngBlock)new Subheading(this.context, style));
        holder.setCode((CodeBlock)new Code(this.context, style));
        holder.setUnorderedList((UnorderedListBlock)new UnorderedList(this.context, style));
        holder.setOrderedList((OrderedListBlock)new OrderedList(this.context, style));
        holder.setImage((ImageBlock)new NetworkImage(this.context, style));
        holder.setLocalImage((LocalImageBlock)new LocalImage(this.context, style));
        holder.setButton((ButtonBlock)new Button(this.context, style));
        holder.setAttachmentList((AttachmentListBlock)new Attachment(this.context, style));
        holder.setLocalAttachment((LocalAttachmentBlock)new LocalAttachment(this.context, style));
        holder.setTwitterButton((TwitterBlock)new Twitter(this.context, style));
        holder.setFacebookButton((FacebookBlock)new Facebook(this.context, style));
        holder.setVideo((VideoBlock)new Video(this.context, style));
        holder.setLwr((LightWeightReplyBlock)new LightWeightReply(this.context, style, listener));
        return holder;
    }
}

