/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.preview.PreviewService;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=15)
public class Lifecycles
implements Application.ActivityLifecycleCallbacks {
    private static final int SESSION_TIMEOUT = 20000;
    private static boolean backgrounded = true;
    private final Set<String> mAttachedActivities = new HashSet<String>();
    private long enteredBackgroundAt = Long.MAX_VALUE;

    public static boolean isAppBackgrounded() {
        return backgrounded;
    }

    private static boolean isScreenLocked() {
        KeyguardManager keyguardManager = (KeyguardManager)Bridge.getContext().getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void startChatHeadService(Context context) {
        Intent intent = new Intent(context, PreviewService.class);
        context.startService(intent);
        Bridge.getNexusClient().connect(Bridge.getIdentityStore().getAppConfig().getRealTimeConfig(), true);
    }

    private void killChathead(Context context) {
        Intent intent = new Intent(context, PreviewService.class);
        context.stopService(intent);
        Bridge.getNexusClient().disconnect();
    }

    private void attachActivity(Activity activity) {
        this.mAttachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.mAttachedActivities.remove(activity.getClass().getName());
    }

    private boolean isApplicationInBackground(Activity activity) {
        if (Lifecycles.isScreenLocked()) {
            return true;
        }
        boolean configurationChanged = activity.isChangingConfigurations();
        return this.mAttachedActivities.isEmpty() && !configurationChanged;
    }

    private void appEnteredBackground(Activity activity) {
        Logger.INTERNAL("lifecycles", "backgrounded");
        this.killChathead(activity.getApplicationContext());
        this.enteredBackgroundAt = System.currentTimeMillis();
    }

    private void appEnteredForeground(Activity activity) {
        Logger.INTERNAL("lifecycles", "foregrounded");
        if (System.currentTimeMillis() - this.enteredBackgroundAt > 20000L) {
            Bridge.getApi().ping();
            Logger.INTERNAL("sdk ping", "backgrounded ping from lifecycles");
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        Logger.INTERNAL("lifecycles", "on create");
        Bridge.init(activity.getApplicationContext());
    }

    public void onActivityStarted(Activity activity) {
        Logger.INTERNAL("lifecycles", "on start");
        Bridge.init(activity.getApplicationContext());
        this.attachActivity(activity);
        if (backgrounded) {
            backgrounded = false;
            this.appEnteredForeground(activity);
        }
        if (!(activity instanceof MainActivity)) {
            this.startChatHeadService(activity.getApplicationContext());
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        Logger.INTERNAL("lifecycles", "on resume");
        Bridge.init(activity.getApplicationContext());
        this.attachActivity(activity);
        Gcm.clearNotifications((Context)activity);
    }

    public void onActivityPaused(Activity activity) {
        Logger.INTERNAL("lifecycles", "on pause");
        this.detachActivity(activity);
    }

    public void onActivityStopped(Activity activity) {
        Logger.INTERNAL("lifecycles", "on stop");
        if (this.isApplicationInBackground(activity)) {
            backgrounded = true;
            this.appEnteredBackground(activity);
        } else {
            this.detachActivity(activity);
        }
    }

    public void onActivityDestroyed(Activity activity) {
        Logger.INTERNAL("lifecycles", "on destroy");
    }
}

