/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.lightbox;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.lightbox.LightboxPresenter;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.views.AttachedImageView;
import io.intercom.com.squareup.picasso.Callback;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.RequestCreator;
import io.intercom.uk.co.senab.photoview.PhotoViewAttacher;

@TargetApi(value=15)
public class LightboxActivity
extends Activity {
    public static final String IMAGE_URL = "image_url";
    public static final String IMAGE_WIDTH = "image_width";
    public static final String IMAGE_HEIGHT = "image_height";
    private static final float MAXIMUM_SCALE = 8.0f;
    private static final float MEDIUM_SCALE = 3.5f;
    private LightboxPresenter presenter;
    private AttachedImageView imageView;
    private ProgressBar progressBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercomsdk_activity_lightbox);
        final Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            this.presenter = new LightboxPresenter(this);
            this.imageView = (AttachedImageView)this.findViewById(R.id.lightbox_image);
            this.imageView.setOnAttachedToWindowListener(new AttachedImageView.OnAttachedToWindowListener(){

                @Override
                public void callback() {
                    String url = extras.getString(LightboxActivity.IMAGE_URL, "");
                    int width = extras.getInt(LightboxActivity.IMAGE_WIDTH, 0);
                    int height = extras.getInt(LightboxActivity.IMAGE_HEIGHT, 0);
                    LightboxActivity.this.presenter.prepareImage(url, width, height, LightboxActivity.this.imageView.isHardwareAccelerated());
                }
            });
            this.progressBar = (ProgressBar)this.findViewById(R.id.loading_wheel);
        } else {
            IntercomLogger.ERROR("Invalid parameters used, cannot display image");
            this.finish();
        }
    }

    protected void displayImage(String url, int targetWidth, int targetHeight) {
        RequestCreator requestCreator = Picasso.with((Context)this).load(url);
        if (targetWidth > 0 || targetHeight > 0) {
            requestCreator.resize(targetWidth, targetHeight).onlyScaleDown();
        }
        requestCreator.into((ImageView)this.imageView, new Callback(){

            public void onSuccess() {
                IntercomLogger.INTERNAL("lightbox", "SUCCESS");
                PhotoViewAttacher photoViewAttacher = new PhotoViewAttacher(LightboxActivity.this.imageView);
                photoViewAttacher.setMaximumScale(8.0f);
                photoViewAttacher.setMediumScale(3.5f);
                LightboxActivity.this.progressBar.setVisibility(8);
                LightboxActivity.this.imageView.setVisibility(0);
            }

            public void onError() {
                IntercomLogger.INTERNAL("lightbox", "FAIL");
            }
        });
    }
}

