/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.os.Handler;
import android.os.HandlerThread;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import io.intercom.com.squareup.okhttp.OkHttpClient;
import io.intercom.com.squareup.okhttp.Request;
import io.intercom.com.squareup.okhttp.RequestBody;
import io.intercom.com.squareup.okhttp.Response;
import io.intercom.com.squareup.okhttp.ResponseBody;
import io.intercom.com.squareup.okhttp.ws.WebSocket;
import io.intercom.com.squareup.okhttp.ws.WebSocketCall;
import io.intercom.com.squareup.okhttp.ws.WebSocketListener;
import io.intercom.okio.Buffer;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class NexusSocket
implements WebSocketListener {
    private static final int OK_CLIENT_DISCONNECT = 4000;
    private static final int N_TIMEOUT_DISCONNECT = 4001;
    private static final int MAX_RECONNECT_TIME = 256;
    private static final String HEADER = "?X-Nexus-Version=android.1.0.11";
    private final NexusListener eventNotifier;
    private final Handler backgroundHandler;
    private final String nexusUrl;
    private final long connectionTimeout;
    private final boolean shouldSendPresence;
    private WebSocket socket = new ClosedSocket();
    private Runnable timeoutRunnable = new Runnable(){

        @Override
        public void run() {
            NexusSocket.this.timedOut();
        }
    };
    private long lastReconnectAt = 0L;
    private int reconnectAttempts = 0;

    public NexusSocket(String nexusUrl, int connectionTimeout, boolean shouldSendPresence, NexusListener eventNotifier) {
        this.nexusUrl = nexusUrl;
        this.connectionTimeout = TimeUnit.SECONDS.toMillis(connectionTimeout);
        this.shouldSendPresence = shouldSendPresence;
        this.eventNotifier = eventNotifier;
        HandlerThread bgThread = new HandlerThread("background-handler");
        bgThread.start();
        this.backgroundHandler = new Handler(bgThread.getLooper());
        this.connect(nexusUrl);
    }

    private void connect(String url) {
        NexusLogger.d("connecting to a socket...");
        this.socket = new ConnectingSocket();
        final OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(20L, TimeUnit.SECONDS);
        client.setReadTimeout(130L, TimeUnit.SECONDS);
        client.setWriteTimeout(130L, TimeUnit.SECONDS);
        final Request request = new Request.Builder().url(url + HEADER).build();
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                WebSocketCall.create(client, request).enqueue(NexusSocket.this);
                client.getDispatcher().getExecutorService().shutdown();
            }
        });
        this.backgroundHandler.postDelayed(this.timeoutRunnable, this.connectionTimeout);
    }

    public void fire(final String data) {
        if (!data.isEmpty()) {
            this.backgroundHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        NexusLogger.v("firing: " + data);
                        NexusSocket.this.socket.sendMessage(RequestBody.create(WebSocket.TEXT, data));
                    }
                    catch (IOException | IllegalStateException e) {
                        NexusLogger.errorLog("fire: " + data, e);
                    }
                }
            });
        }
    }

    public void disconnect() {
        this.disconnect(4000);
    }

    public boolean isConnected() {
        return !(this.socket instanceof ClosedSocket);
    }

    private void disconnect(final int code) {
        this.backgroundHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    NexusSocket.this.socket.close(code, "Goodbye, world!");
                }
                catch (IOException e) {
                    NexusLogger.errorLog("disconnect: failed " + e.getMessage());
                    NexusLogger.errorLog("disconnect: failed", e);
                }
                catch (IllegalStateException ex) {
                    NexusLogger.errorLog("disconnect: socket already closed", ex);
                }
            }
        });
    }

    private void timedOut() {
        if (this.socket == null) {
            this.connect(this.nexusUrl);
        } else {
            this.disconnect(4001);
        }
        this.eventNotifier.onConnectFailed();
    }

    private void resetTimeout() {
        this.backgroundHandler.removeCallbacks(this.timeoutRunnable);
        this.backgroundHandler.postDelayed(this.timeoutRunnable, this.connectionTimeout);
    }

    private void scheduleReconnect() {
        this.modifyReconnectAttempts();
        this.backgroundHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                NexusSocket.this.connect(NexusSocket.this.nexusUrl);
            }
        }, NexusSocket.calculateReconnectTimerInMS(this.reconnectAttempts));
    }

    private void modifyReconnectAttempts() {
        long maxReconnectTimeIncludingJitter;
        long millisSinceLastAttempt = System.currentTimeMillis() - this.lastReconnectAt;
        if (millisSinceLastAttempt > (maxReconnectTimeIncludingJitter = TimeUnit.SECONDS.toMillis(256L) * 2L)) {
            NexusLogger.d("resetting reconnection attempts");
            this.reconnectAttempts = 1;
        } else {
            NexusLogger.d("incrementing reconnection attempts");
            ++this.reconnectAttempts;
        }
        this.lastReconnectAt = System.currentTimeMillis();
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        NexusLogger.d("onOpen: " + response.message());
        this.socket = webSocket;
        this.resetTimeout();
        if (this.shouldSendPresence) {
            this.fire(NexusEvent.UserPresence.toJsonFormattedString());
        }
        this.eventNotifier.onConnect();
    }

    @Override
    public void onMessage(ResponseBody message) throws IOException {
        String s;
        this.resetTimeout();
        if (message.contentType() == WebSocket.TEXT && !(s = message.string()).isEmpty() && !s.equals(" ")) {
            try {
                JSONObject jObject = new JSONObject(s);
                String eventName = jObject.optString("eventName");
                if (!eventName.isEmpty() && !eventName.equals("ACK")) {
                    NexusLogger.v("onMessage TEXT: " + s + " length: " + s.length());
                    NexusEvent event = NexusEvent.parse(jObject);
                    this.eventNotifier.notifyEvent(event);
                } else {
                    NexusLogger.d("onMessage ACK: " + s);
                }
            }
            catch (JSONException e) {
                NexusLogger.errorLog("onMessage: json parse exception for message: " + s);
                NexusLogger.errorLog("onMessage: json parse exception", (Exception)((Object)e));
            }
        }
        message.close();
    }

    @Override
    public void onPong(Buffer payload) {
        payload.close();
    }

    @Override
    public void onClose(int code, String reason) {
        switch (code) {
            case 4000: {
                this.shutdown();
                break;
            }
            default: {
                this.scheduleReconnect();
            }
        }
        NexusLogger.d("onClose code: " + code + " reason: " + reason);
    }

    @Override
    public void onFailure(IOException e, Response response) {
        if (NexusSocket.shouldReconnectFromFailure(e.getMessage())) {
            this.scheduleReconnect();
        } else {
            this.shutdown();
        }
        NexusLogger.errorLog("onFailure: " + e.getMessage(), e);
        NexusLogger.errorLog("onFailure: " + response, e);
        this.eventNotifier.onConnectFailed();
    }

    private void shutdown() {
        this.socket = new ClosedSocket();
        this.backgroundHandler.removeCallbacksAndMessages(null);
        this.backgroundHandler.getLooper().quit();
    }

    public static long calculateReconnectTimerInMS(int reconnectAttempts) {
        int minimumBackoffSeconds = (int)Math.min(Math.pow(2.0, reconnectAttempts), 256.0);
        int jitter = new Random().nextInt(minimumBackoffSeconds + 1);
        long millis = TimeUnit.SECONDS.toMillis(minimumBackoffSeconds + jitter);
        NexusLogger.d("Scheduling reconnect in: " + millis + " for attempt: " + reconnectAttempts);
        return millis;
    }

    static boolean shouldReconnectFromFailure(String exception) {
        String okhttpOpeningError = "Expected HTTP 101 response but was";
        if (exception != null) {
            if (exception.equals("closed")) {
                return false;
            }
            if (exception.startsWith(okhttpOpeningError)) {
                return exception.substring(okhttpOpeningError.length()).startsWith(" '5");
            }
        }
        return true;
    }

    private class ClosedSocket
    extends DummySocket {
        private ClosedSocket() {
        }
    }

    private class ConnectingSocket
    extends DummySocket {
        private ConnectingSocket() {
        }
    }

    private class DummySocket
    implements WebSocket {
        private DummySocket() {
        }

        @Override
        public void sendMessage(RequestBody message) throws IOException {
        }

        @Override
        public void sendPing(Buffer payload) throws IOException {
        }

        @Override
        public void close(int code, String reason) throws IOException {
        }
    }
}

