/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.retrofit.Callback;
import io.intercom.retrofit.http.Body;
import io.intercom.retrofit.http.GET;
import io.intercom.retrofit.http.POST;
import io.intercom.retrofit.http.PUT;
import io.intercom.retrofit.http.Path;
import io.intercom.retrofit.http.QueryMap;
import java.util.Map;

public interface IntercomApiInterface {
    @POST(value="/conversations")
    public void startNewConversation(@Body Map<String, Object> var1, Callback<Conversation.Builder> var2);

    @POST(value="/conversations/{conversationId}/reply")
    public void replyToConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2, Callback<Part.Builder> var3);

    @POST(value="/conversations/{conversationId}/read")
    public void markAsRead(@Path(value="conversationId") String var1, @Body Map<String, Object> var2, Callback<ReadResponse.Builder> var3);

    @GET(value="/conversations")
    public void getConversations(@QueryMap Map<String, Object> var1, Callback<ConversationsResponse.Builder> var2);

    @GET(value="/conversations/unread")
    public void getUnreadConversations(@QueryMap Map<String, Object> var1, Callback<UsersResponse.Builder> var2);

    @GET(value="/conversations/{conversationId}")
    public void getConversation(@Path(value="conversationId") String var1, @QueryMap Map<String, Object> var2, Callback<Conversation.Builder> var3);

    @POST(value="/users")
    public void updateUser(@Body Map<String, Object> var1, Callback<UsersResponse.Builder> var2);

    @POST(value="/events")
    public void logEvent(@Body Map<String, Object> var1, Callback<UsersResponse.Builder> var2);

    @POST(value="/uploads")
    public void uploadFile(@Body Map<String, Object> var1, Callback<Upload.Builder> var2);

    @PUT(value="/users/device_tokens")
    public void deleteDeviceToken(@Body Map<String, Object> var1, Callback<UsersResponse.Builder> var2);
}

