/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.registry.PropertyRegistry;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u000b"}, d2={"saveProperties", "", "Lorg/koin/core/registry/PropertyRegistry;", "properties", "Ljava/util/Properties;", "loadPropertiesFromFile", "fileName", "", "readDataFromFile", "content", "loadEnvironmentProperties", "koin-core"})
@SourceDebugExtension(value={"SMAP\nPropertyRegistryExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,58:1\n216#2,2:59\n*S KotlinDebug\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n*L\n18#1:59,2\n*E\n"})
public final class PropertyRegistryExtKt {
    public static final void saveProperties(@NotNull PropertyRegistry $this$saveProperties, @NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkNotNullParameter((Object)$this$saveProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        $this$saveProperties.get_koin$koin_core().getLogger().debug("load " + properties.size() + " properties");
        Map map = MapsKt.toMap((Map)properties);
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            $this$saveProperties.saveProperty$koin_core(k, v);
        }
    }

    public static final void loadPropertiesFromFile(@NotNull PropertyRegistry $this$loadPropertiesFromFile, @NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loadPropertiesFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().debug("load properties from " + fileName);
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            string = new String(byArray, charset);
        } else {
            string = content = null;
        }
        if (content == null) {
            throw new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().info("loaded properties from file:'" + fileName + '\'');
        Properties properties = PropertyRegistryExtKt.readDataFromFile(content);
        PropertyRegistryExtKt.saveProperties($this$loadPropertiesFromFile, properties);
    }

    private static final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public static final void loadEnvironmentProperties(@NotNull PropertyRegistry $this$loadEnvironmentProperties) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)$this$loadEnvironmentProperties, (String)"<this>");
        $this$loadEnvironmentProperties.get_koin$koin_core().getLogger().debug("load properties from environment");
        Properties sysProperties = System.getProperties();
        Intrinsics.checkNotNull((Object)sysProperties);
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysProperties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        Map<String, String> map2 = map;
        Properties properties2 = properties = new Properties();
        properties2.putAll(map2);
        Properties sysEnvProperties = properties;
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysEnvProperties);
    }
}

