/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.error.ScopeAlreadyCreatedException;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.module.Module;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.qualifier.StringQualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0018H\u0002J(\u0010\u001b\u001a\u00020\r2\n\u0010\u001c\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u001d\u001a\u00020\u00072\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0001J\u0015\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\rH\u0000\u00a2\u0006\u0002\b!J\u0019\u0010\u001f\u001a\u00020\u00182\n\u0010\u001c\u001a\u00060\u000bj\u0002`\fH\u0000\u00a2\u0006\u0002\b!J\u0016\u0010\"\u001a\u0004\u0018\u00010\r2\n\u0010\u001c\u001a\u00060\u000bj\u0002`\fH\u0001J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/koin/core/registry/ScopeRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_scopeDefinitions", "Ljava/util/HashSet;", "Lorg/koin/core/qualifier/Qualifier;", "Lkotlin/collections/HashSet;", "_scopes", "", "", "Lorg/koin/core/scope/ScopeID;", "Lorg/koin/core/scope/Scope;", "rootScope", "getRootScope$annotations", "()V", "getRootScope", "()Lorg/koin/core/scope/Scope;", "scopeDefinitions", "", "getScopeDefinitions", "()Ljava/util/Set;", "close", "", "close$koin_core", "closeAllScopes", "createScope", "scopeId", "qualifier", "source", "deleteScope", "scope", "deleteScope$koin_core", "getScopeOrNull", "loadModule", "module", "Lorg/koin/core/module/Module;", "loadScopes", "modules", "Companion", "koin-core"})
@SourceDebugExtension(value={"SMAP\nScopeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n+ 2 Logger.kt\norg/koin/core/logger/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n28#2:112\n46#2,2:113\n29#2:115\n36#2,12:116\n1#3:128\n1855#4,2:129\n1855#4,2:131\n*S KotlinDebug\n*F\n+ 1 ScopeRegistry.kt\norg/koin/core/registry/ScopeRegistry\n*L\n60#1:112\n60#1:113,2\n60#1:115\n62#1:116,12\n91#1:129,2\n97#1:131,2\n*E\n"})
public final class ScopeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin _koin;
    @NotNull
    private final HashSet<Qualifier> _scopeDefinitions;
    @NotNull
    private final Map<String, Scope> _scopes;
    @NotNull
    private final Scope rootScope;
    @NotNull
    private static final String ROOT_SCOPE_ID = "_root_";
    @NotNull
    private static final StringQualifier rootScopeQualifier = QualifierKt._q("_root_");

    public ScopeRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._scopeDefinitions = new HashSet();
        this._scopes = KoinPlatformTools.INSTANCE.safeHashMap();
        this.rootScope = new Scope(rootScopeQualifier, ROOT_SCOPE_ID, true, this._koin);
        this._scopeDefinitions.add(this.rootScope.getScopeQualifier());
        this._scopes.put(this.rootScope.getId(), this.rootScope);
    }

    @NotNull
    public final Set<Qualifier> getScopeDefinitions() {
        return this._scopeDefinitions;
    }

    @NotNull
    public final Scope getRootScope() {
        return this.rootScope;
    }

    @KoinInternalApi
    public static /* synthetic */ void getRootScope$annotations() {
    }

    @PublishedApi
    @Nullable
    public final Scope getScopeOrNull(@NotNull String scopeId) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        return this._scopes.get(scopeId);
    }

    @PublishedApi
    @NotNull
    public final Scope createScope(@NotNull String scopeId, @NotNull Qualifier qualifier, @Nullable Object source) {
        Logger this_$iv$iv;
        Logger this_$iv;
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        Logger logger = this._koin.getLogger();
        String msg$iv = "|- (+) Scope - id:'" + scopeId + "' q:" + qualifier;
        boolean $i$f$debug = false;
        void var7_8 = this_$iv;
        Level lvl$iv$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isAt(lvl$iv$iv)) {
            this_$iv$iv.display(lvl$iv$iv, msg$iv);
        }
        if (!this._scopeDefinitions.contains(qualifier)) {
            this_$iv = this._koin.getLogger();
            msg$iv = "| Scope '" + qualifier + "' not defined. Creating it ...";
            boolean $i$f$warn = false;
            this_$iv$iv = this_$iv;
            lvl$iv$iv = Level.WARNING;
            $i$f$log = false;
            if (this_$iv$iv.isAt(lvl$iv$iv)) {
                this_$iv$iv.display(lvl$iv$iv, msg$iv);
            }
            this._scopeDefinitions.add(qualifier);
        }
        if (this._scopes.containsKey(scopeId)) {
            throw new ScopeAlreadyCreatedException("Scope with id '" + scopeId + "' is already created");
        }
        Scope scope = new Scope(qualifier, scopeId, false, this._koin, 4, null);
        Object object = source;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            scope.set_source(source);
        }
        Scope[] scopeArray = new Scope[]{this.rootScope};
        scope.linkTo(scopeArray);
        this._scopes.put(scopeId, scope);
        return scope;
    }

    public static /* synthetic */ Scope createScope$default(ScopeRegistry scopeRegistry, String string, Qualifier qualifier, Object object, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return scopeRegistry.createScope(string, qualifier, object);
    }

    public final void deleteScope$koin_core(@NotNull String scopeId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
            Scope scope = this._scopes.get(scopeId);
            if (scope == null) break block0;
            Scope it = scope;
            boolean bl = false;
            this.deleteScope$koin_core(it);
        }
    }

    public final void deleteScope$koin_core(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._koin.getInstanceRegistry().dropScopeInstances$koin_core(scope);
        this._scopes.remove(scope.getId());
    }

    public final void close$koin_core() {
        this.closeAllScopes();
        this._scopes.clear();
        this._scopeDefinitions.clear();
    }

    private final void closeAllScopes() {
        Iterable $this$forEach$iv = this._scopes.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope scope = (Scope)element$iv;
            boolean bl = false;
            scope.close();
        }
    }

    public final void loadScopes(@NotNull Set<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.loadModule(it);
        }
    }

    private final void loadModule(Module module) {
        this._scopeDefinitions.addAll((Collection<Qualifier>)module.getScopes());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/koin/core/registry/ScopeRegistry$Companion;", "", "()V", "ROOT_SCOPE_ID", "", "rootScopeQualifier", "Lorg/koin/core/qualifier/StringQualifier;", "getRootScopeQualifier$annotations", "getRootScopeQualifier", "()Lorg/koin/core/qualifier/StringQualifier;", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringQualifier getRootScopeQualifier() {
            return rootScopeQualifier;
        }

        @PublishedApi
        public static /* synthetic */ void getRootScopeQualifier$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

