/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.core.registry.PropertyRegistry;
import org.koin.ext.StringExtKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"readDataFromFile", "Ljava/util/Properties;", "content", "", "loadEnvironmentProperties", "", "Lorg/koin/core/registry/PropertyRegistry;", "loadPropertiesFromFile", "fileName", "saveProperties", "properties", "koin-core"})
public final class PropertyRegistryExtKt {
    /*
     * WARNING - void declaration
     */
    public static final void saveProperties(@NotNull PropertyRegistry $this$saveProperties, @NotNull Properties properties) {
        Map propertiesMapValues;
        Intrinsics.checkNotNullParameter((Object)$this$saveProperties, (String)"$this$saveProperties");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if ($this$saveProperties.get_koin$koin_core().getLogger().isAt(Level.DEBUG)) {
            $this$saveProperties.get_koin$koin_core().getLogger().debug("load " + properties.size() + " properties");
        }
        Map map = MapsKt.toMap((Map)properties);
        if (map == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        }
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry element$iv;
            Map.Entry $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$k$v;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$k$v;
            bl3 = false;
            String v = (String)entry.getValue();
            $this$saveProperties.saveProperty$koin_core((String)k, StringExtKt.quoted(v));
        }
    }

    public static final void loadPropertiesFromFile(@NotNull PropertyRegistry $this$loadPropertiesFromFile, @NotNull String fileName) {
        String content;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$loadPropertiesFromFile, (String)"$this$loadPropertiesFromFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if ($this$loadPropertiesFromFile.get_koin$koin_core().getLogger().isAt(Level.DEBUG)) {
            $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().debug("load properties from " + fileName);
        }
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            string = new String(byArray, charset);
        } else {
            string = content = null;
        }
        if (content != null) {
            if ($this$loadPropertiesFromFile.get_koin$koin_core().getLogger().isAt(Level.INFO)) {
                $this$loadPropertiesFromFile.get_koin$koin_core().getLogger().info("loaded properties from file:'" + fileName + '\'');
            }
        } else {
            throw (Throwable)new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = PropertyRegistryExtKt.readDataFromFile(content);
        PropertyRegistryExtKt.saveProperties($this$loadPropertiesFromFile, properties);
    }

    private static final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    public static final void loadEnvironmentProperties(@NotNull PropertyRegistry $this$loadEnvironmentProperties) {
        Properties sysProperties;
        Intrinsics.checkNotNullParameter((Object)$this$loadEnvironmentProperties, (String)"$this$loadEnvironmentProperties");
        if ($this$loadEnvironmentProperties.get_koin$koin_core().getLogger().isAt(Level.DEBUG)) {
            $this$loadEnvironmentProperties.get_koin$koin_core().getLogger().debug("load properties from environment");
        }
        Properties properties = sysProperties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"sysProperties");
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, properties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"System.getenv()");
        Map<String, String> map2 = map;
        boolean bl = false;
        Properties properties2 = new Properties();
        boolean bl2 = false;
        boolean bl3 = false;
        Properties properties3 = properties2;
        boolean bl4 = false;
        properties3.putAll(map2);
        Properties sysEnvProperties = properties2;
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysEnvProperties);
    }
}

