/*
 * Decompiled with CFR 0.152.
 */
package org.koin.androidx.scope;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinScopeComponentKt;
import org.koin.core.context.GlobalContext;
import org.koin.core.context.KoinContext;
import org.koin.core.logger.Logger;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B-\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/koin/androidx/scope/LifecycleScopeDelegate;", "Lkotlin/properties/ReadOnlyProperty;", "Landroidx/lifecycle/LifecycleOwner;", "Lorg/koin/core/scope/Scope;", "lifecycleOwner", "koinContext", "Lorg/koin/core/context/KoinContext;", "createScope", "Lkotlin/Function1;", "Lorg/koin/core/Koin;", "(Landroidx/lifecycle/LifecycleOwner;Lorg/koin/core/context/KoinContext;Lkotlin/jvm/functions/Function1;)V", "_scope", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "koin-android_release"})
public final class LifecycleScopeDelegate
implements ReadOnlyProperty<LifecycleOwner, Scope> {
    @NotNull
    private final LifecycleOwner lifecycleOwner;
    @Nullable
    private Scope _scope;

    public LifecycleScopeDelegate(@NotNull LifecycleOwner lifecycleOwner, @NotNull KoinContext koinContext, @NotNull Function1<? super Koin, Scope> createScope) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)koinContext, (String)"koinContext");
        Intrinsics.checkNotNullParameter(createScope, (String)"createScope");
        this.lifecycleOwner = lifecycleOwner;
        Koin koin = koinContext.get();
        final Logger logger = koin.getLogger();
        logger.debug("setup scope: " + this._scope + " for " + this.lifecycleOwner);
        String scopeId = KoinScopeComponentKt.getScopeId((Object)this.lifecycleOwner);
        Scope scope = koin.getScopeOrNull(scopeId);
        this._scope = scope == null ? (Scope)createScope.invoke((Object)koin) : scope;
        logger.debug("got scope: " + this._scope + " for " + this.lifecycleOwner);
        this.lifecycleOwner.getLifecycle().addObserver(new LifecycleObserver(){

            @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
            public final void onDestroy(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                logger.debug("Closing scope: " + _scope + " for " + this.getLifecycleOwner());
                Scope scope = _scope;
                if (Intrinsics.areEqual((Object)(scope == null ? null : Boolean.valueOf(scope.getClosed())), (Object)false) && (scope = _scope) != null) {
                    scope.close();
                }
                _scope = null;
            }
        });
    }

    public /* synthetic */ LifecycleScopeDelegate(final LifecycleOwner lifecycleOwner, KoinContext koinContext, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            koinContext = (KoinContext)GlobalContext.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<Koin, Scope>(){

                @NotNull
                public final Scope invoke(@NotNull Koin koin) {
                    Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
                    return Koin.createScope$default((Koin)koin, (String)KoinScopeComponentKt.getScopeId((Object)lifecycleOwner), (Qualifier)((Qualifier)KoinScopeComponentKt.getScopeName((Object)lifecycleOwner)), null, (int)4, null);
                }
            };
        }
        this(lifecycleOwner, koinContext, (Function1<? super Koin, Scope>)function1);
    }

    @NotNull
    public final LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    @NotNull
    public Scope getValue(@NotNull LifecycleOwner thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Scope scope = this._scope;
        if (scope == null) {
            String string = Intrinsics.stringPlus((String)"can't get Scope for ", (Object)this.lifecycleOwner);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return scope;
    }
}

