/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowExternalFunction
extends Statement {
    private final QualifiedName name;
    private final Optional<List<String>> parameterTypes;

    public ShowExternalFunction(QualifiedName name, Optional<List<String>> parameterTypes) {
        this(Optional.empty(), name, parameterTypes);
    }

    public ShowExternalFunction(NodeLocation location, QualifiedName name, Optional<List<String>> parameterTypes) {
        this(Optional.of(location), name, parameterTypes);
    }

    private ShowExternalFunction(Optional<NodeLocation> location, QualifiedName name, Optional<List<String>> parameterTypes) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<List<String>> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowExternalFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameterTypes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowExternalFunction o = (ShowExternalFunction)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.parameterTypes, o.parameterTypes);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameterTypes", this.parameterTypes).toString();
    }
}

