/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Grant
extends Statement {
    private final Optional<List<String>> privileges;
    private final boolean table;
    private final QualifiedName tableName;
    private final PrincipalSpecification grantee;
    private final boolean withGrantOption;

    public Grant(Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee, boolean withGrantOption) {
        this(Optional.empty(), privileges, table, tableName, grantee, withGrantOption);
    }

    public Grant(NodeLocation location, Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee, boolean withGrantOption) {
        this(Optional.of(location), privileges, table, tableName, grantee, withGrantOption);
    }

    private Grant(Optional<NodeLocation> location, Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee, boolean withGrantOption) {
        super(location);
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.table = table;
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
        this.withGrantOption = withGrantOption;
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public boolean isTable() {
        return this.table;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    public boolean isWithGrantOption() {
        return this.withGrantOption;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGrant(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.privileges, this.table, this.tableName, this.grantee, this.withGrantOption);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Grant o = (Grant)obj;
        return Objects.equals(this.privileges, o.privileges) && Objects.equals(this.table, o.table) && Objects.equals(this.tableName, o.tableName) && Objects.equals(this.grantee, o.grantee) && Objects.equals(this.withGrantOption, o.withGrantOption);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privileges", this.privileges).add("table", this.table).add("tableName", (Object)this.tableName).add("grantee", (Object)this.grantee).add("withGrantOption", this.withGrantOption).toString();
    }
}

