/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionProperty
extends Node {
    private final Identifier name;
    private final StringLiteral value;

    public FunctionProperty(Identifier name, StringLiteral value) {
        this(Optional.empty(), name, value);
    }

    public FunctionProperty(NodeLocation location, Identifier name, StringLiteral value) {
        this(Optional.of(location), name, value);
    }

    private FunctionProperty(Optional<NodeLocation> location, Identifier name, StringLiteral value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public StringLiteral getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionProperty(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.name, (Object)this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionProperty other = (FunctionProperty)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }
}

