/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropCube
extends Statement {
    private final QualifiedName cubeName;
    private final boolean exists;

    public DropCube(QualifiedName cubeName, boolean exists) {
        this(Optional.empty(), cubeName, exists);
    }

    public DropCube(NodeLocation location, QualifiedName cubeName, boolean exists) {
        this(Optional.of(location), cubeName, exists);
    }

    private DropCube(Optional<NodeLocation> location, QualifiedName cubeName, boolean exists) {
        super(location);
        this.cubeName = cubeName;
        this.exists = exists;
    }

    public QualifiedName getCubeName() {
        return this.cubeName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropCube(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cubeName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropCube o = (DropCube)obj;
        return Objects.equals(this.cubeName, o.cubeName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cubeName", (Object)this.cubeName).add("exists", this.exists).toString();
    }
}

