/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jodabridge;

import io.airlift.jodabridge.JdkBasedDateTimeZone;
import java.time.zone.ZoneRulesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.joda.time.tz.Provider;

public class JdkBasedZoneInfoProvider
implements Provider {
    private static final Map<String, DateTimeZone> zones;

    public DateTimeZone getZone(String id) {
        if (id.startsWith("+") || id.startsWith("-")) {
            return null;
        }
        return zones.get(id);
    }

    public Set<String> getAvailableIDs() {
        return ZoneRulesProvider.getAvailableZoneIds();
    }

    public static void registerAsJodaZoneInfoProvider() {
        System.setProperty("org.joda.time.DateTimeZone.Provider", JdkBasedZoneInfoProvider.class.getName());
        if (!(DateTimeZone.getProvider() instanceof JdkBasedZoneInfoProvider)) {
            throw new RuntimeException("This method must be invoked before any use of Joda-Time");
        }
    }

    static {
        HashMap<String, DateTimeZone> zonesBuilder = new HashMap<String, DateTimeZone>();
        for (String zoneId : ZoneRulesProvider.getAvailableZoneIds()) {
            Object zone = zoneId.equals("UTC") ? DateTimeZone.UTC : new JdkBasedDateTimeZone(zoneId);
            zonesBuilder.put(zoneId, (DateTimeZone)zone);
        }
        zones = Collections.unmodifiableMap(zonesBuilder);
    }
}

