/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.client;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterTable;
import io.hetu.core.plugin.datacenter.GlobalQueryIdGenerator;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.prestosql.client.DataCenterClientSession;
import io.prestosql.client.DataCenterStatementClient;
import io.prestosql.client.JsonResponse;
import io.prestosql.client.QueryError;
import io.prestosql.client.QueryStatusInfo;
import io.prestosql.client.StatementClient;
import io.prestosql.client.util.HttpUtil;
import io.prestosql.client.util.TypeUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.PrestoTransportException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.statistics.ColumnStatistics;
import io.prestosql.spi.statistics.DoubleRange;
import io.prestosql.spi.statistics.Estimate;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.net.URI;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class DataCenterClient {
    private static final JsonCodec<Integer> INTEGER_JSON_CODEC = JsonCodec.jsonCodec(Integer.class);
    private static final String EXCHANGE_COMPRESSION = "exchange_compression";
    private static final String SPLIT_DOT = ".";
    private static final int TYPE_POSITION = 4;
    private static final int DEFAULT_SPLIT_COUNT = 1;
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final HttpUrl serverUri;
    private final DataCenterClientSession clientSession;
    private final GlobalQueryIdGenerator globalQueryIdGenerator;
    private final DataCenterConfig config;
    private final OkHttpClient httpClient;
    private TypeManager typeManager;

    @Inject
    public DataCenterClient(DataCenterConfig config, OkHttpClient httpClient, TypeManager typeManager) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.config = Objects.requireNonNull(config, "config is null");
        this.serverUri = HttpUrl.get((URI)config.getConnectionUrl());
        if (this.serverUri == null) {
            throw new RuntimeException("Invalid connect-url :" + config.getConnectionUrl().toString());
        }
        if (config.isCompressionEnabled()) {
            properties.put(EXCHANGE_COMPRESSION, "true");
        }
        this.clientSession = DataCenterStatementClientFactory.createClientSession(config, typeManager, properties);
        this.httpClient = httpClient;
        this.globalQueryIdGenerator = new GlobalQueryIdGenerator(Optional.ofNullable(config.getRemoteClusterId()));
        this.typeManager = typeManager;
    }

    private static SQLException resultsException(QueryStatusInfo results) {
        QueryError error = Objects.requireNonNull(results.getError());
        String message = String.format("Query failed (#%s): %s", results.getId(), error.getMessage());
        RuntimeException cause = error.getFailureInfo() == null ? null : error.getFailureInfo().toException();
        return new SQLException(message, error.getSqlState(), error.getErrorCode(), cause);
    }

    public Set<String> getCatalogNames() {
        String query = "SELECT * FROM SYSTEM.METADATA.CATALOGS";
        try {
            HashSet<String> catalogNames = new HashSet<String>();
            Iterable<List<Object>> data = this.getResults(this.clientSession, query);
            for (List<Object> row : data) {
                String catalogName = row.get(0).toString();
                if (catalogName.contains(SPLIT_DOT)) continue;
                catalogNames.add(catalogName);
            }
            return catalogNames;
        }
        catch (SQLException ex) {
            throw new PrestoTransportException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, HostAddress.fromUri((URI)this.serverUri.uri()), "could not connect to the data center");
        }
    }

    public Set<String> getSchemaNames(String catalog) {
        Objects.requireNonNull(catalog, "catalog is null");
        String query = "SHOW SCHEMAS FROM " + catalog;
        try {
            Iterable<List<Object>> data = this.getResults(this.clientSession, query);
            HashSet<String> schemaNames = new HashSet<String>();
            for (List<Object> row : data) {
                String schemaName = row.get(0).toString();
                if ("information_schema".equals(schemaName)) continue;
                schemaNames.add(schemaName);
            }
            return schemaNames;
        }
        catch (SQLException ex) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, catalog + " not found, failed to get schema names");
        }
    }

    public Set<String> getTableNames(String catalog, String schema) {
        String query = "SHOW TABLES FROM " + catalog + SPLIT_DOT + schema;
        try {
            Iterable<List<Object>> data = this.getResults(this.clientSession, query);
            HashSet<String> tableNames = new HashSet<String>();
            for (List<Object> row : data) {
                tableNames.add(row.get(0).toString());
            }
            return tableNames;
        }
        catch (SQLException ex) {
            throw new SchemaNotFoundException(catalog + SPLIT_DOT + schema, "Hetu DC connector failed to get table name");
        }
    }

    public DataCenterTable getTable(String catalog, String schema, String tableName) {
        Objects.requireNonNull(catalog, "catalog is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        String query = "SELECT * FROM " + catalog + SPLIT_DOT + schema + SPLIT_DOT + tableName;
        List<DataCenterColumn> columns = this.getColumns(query);
        if (columns.isEmpty()) {
            return null;
        }
        return new DataCenterTable(tableName, columns);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DataCenterColumn> getColumns(String sql) {
        String query = "PREPARE subStatement FROM " + sql;
        String describe = "DESCRIBE OUTPUT subStatement";
        try (StatementClient preparedClient = this.execute(query);){
            DataCenterClientSession newClientSession = DataCenterStatementClientFactory.createClientSession(preparedClient, this.config, this.typeManager);
            ImmutableList.Builder builder = new ImmutableList.Builder();
            Iterable<List<Object>> data = this.getResults(newClientSession, describe);
            for (List<Object> row : data) {
                String name = row.get(0).toString();
                String type = row.get(4).toString();
                if ("unknown".equalsIgnoreCase(type)) {
                    List<DataCenterColumn> list = Collections.emptyList();
                    return list;
                }
                try {
                    builder.add((Object)new DataCenterColumn(name, TypeUtil.parseType((TypeManager)this.typeManager, (String)type)));
                }
                catch (IllegalArgumentException ex) {
                    List<DataCenterColumn> list = Collections.emptyList();
                    if (preparedClient == null) return list;
                    if (var5_6 == null) {
                        preparedClient.close();
                        return list;
                    }
                    try {
                        preparedClient.close();
                        return list;
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                        return list;
                    }
                }
            }
            ImmutableList immutableList = builder.build();
            return immutableList;
        }
        catch (SQLException ex) {
            return Collections.emptyList();
        }
    }

    public TableStatistics getTableStatistics(String tableFullName, Map<String, ColumnHandle> columnHandles) {
        Iterable<List<Object>> data;
        String query = "SHOW STATS FOR " + tableFullName;
        try {
            data = this.getResults(this.clientSession, query);
        }
        catch (SQLException ex) {
            throw new PrestoTransportException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, HostAddress.fromUri((URI)this.serverUri.uri()), "could not connect to the remote data center");
        }
        TableStatistics.Builder builder = TableStatistics.builder();
        List<Object> lastRow = null;
        for (List<Object> row : data) {
            DataCenterColumnHandle columnHandle;
            ColumnStatistics.Builder columnStatisticBuilder = new ColumnStatistics.Builder();
            lastRow = row;
            if (row.get(0) == null || (columnHandle = (DataCenterColumnHandle)columnHandles.get(row.get(0).toString())) == null) continue;
            if (row.get(1) != null) {
                columnStatisticBuilder.setDataSize(Estimate.of((double)Double.parseDouble(row.get(1).toString())));
            }
            if (row.get(2) != null) {
                columnStatisticBuilder.setDistinctValuesCount(Estimate.of((double)Double.parseDouble(row.get(2).toString())));
            }
            if (row.get(3) != null) {
                columnStatisticBuilder.setNullsFraction(Estimate.of((double)Double.parseDouble(row.get(3).toString())));
            }
            if (row.get(5) != null && row.get(6) != null) {
                String minStr = row.get(5).toString();
                String maxStr = row.get(6).toString();
                Type columnType = columnHandle.getColumnType();
                if (columnType.equals(DateType.DATE)) {
                    LocalDate minDate = LocalDate.parse(minStr, DATE_FORMATTER);
                    LocalDate maxDate = LocalDate.parse(maxStr, DATE_FORMATTER);
                    columnStatisticBuilder.setRange(new DoubleRange((double)minDate.toEpochDay(), (double)maxDate.toEpochDay()));
                } else {
                    columnStatisticBuilder.setRange(new DoubleRange(Double.parseDouble(minStr), Double.parseDouble(maxStr)));
                }
            }
            builder.setColumnStatistics((ColumnHandle)columnHandle, columnStatisticBuilder.build());
        }
        if (lastRow != null && lastRow.get(4) != null) {
            builder.setRowCount(Estimate.of((double)Double.parseDouble(lastRow.get(4).toString())));
        }
        return builder.build();
    }

    public int getSplits(String globalQueryId) {
        Integer splitCount;
        HttpUrl url = this.serverUri.newBuilder().encodedPath("/v1/dc/split/" + globalQueryId).build();
        Request request = HttpUtil.prepareRequest((HttpUrl)url, (DataCenterClientSession)this.clientSession).build();
        JsonResponse response = JsonResponse.execute(INTEGER_JSON_CODEC, (OkHttpClient)this.httpClient, (Request)request);
        if (response.getStatusCode() == 200 && response.hasValue() && (splitCount = (Integer)response.getValue()) != null) {
            return splitCount;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatementClient execute(String query) throws SQLException {
        try (DataCenterStatementClient client = DataCenterStatementClient.newStatementClient((OkHttpClient)this.httpClient, (DataCenterClientSession)this.clientSession, (String)query, (String)this.globalQueryIdGenerator.createId());){
            while (client.isRunning()) {
                client.advance();
            }
            Verify.verify((boolean)client.isFinished());
            QueryStatusInfo results = client.finalStatusInfo();
            if (results.getError() != null) {
                throw DataCenterClient.resultsException(results);
            }
            DataCenterStatementClient dataCenterStatementClient = client;
            return dataCenterStatementClient;
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterable<List<Object>> getResults(DataCenterClientSession session, String query) throws SQLException {
        try (DataCenterStatementClient client = DataCenterStatementClient.newStatementClient((OkHttpClient)this.httpClient, (DataCenterClientSession)session, (String)query, (String)this.globalQueryIdGenerator.createId());){
            LinkedList<Iterable> list = new LinkedList<Iterable>();
            while (client.isRunning()) {
                Iterable data;
                if (client.currentData() != null && (data = client.currentData().getData()) != null) {
                    list.add(data);
                }
                client.advance();
            }
            Verify.verify((boolean)client.isFinished());
            QueryStatusInfo results = client.finalStatusInfo();
            if (results.getError() != null) {
                throw DataCenterClient.resultsException(results);
            }
            Iterable iterable = Iterables.concat(list);
            return iterable;
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }
}

