/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.prestosql.spi.connector.ColumnMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DataCenterTable {
    private final String name;
    private final List<DataCenterColumn> columns;
    private final List<ColumnMetadata> columnsMetadata;

    @JsonCreator
    public DataCenterTable(@JsonProperty(value="name") String name, @JsonProperty(value="columns") List<DataCenterColumn> columns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = Objects.requireNonNull(name, "name is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        ImmutableList.Builder columnsMetadataBuilder = ImmutableList.builder();
        for (DataCenterColumn column : this.columns) {
            columnsMetadataBuilder.add((Object)new ColumnMetadata(column.getName(), column.getType()));
        }
        this.columnsMetadata = columnsMetadataBuilder.build();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<DataCenterColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return this.columnsMetadata;
    }
}

