/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterMetadata;
import io.hetu.core.plugin.datacenter.DataCenterSplitManager;
import io.hetu.core.plugin.datacenter.DataCenterTransactionHandle;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.hetu.core.plugin.datacenter.optimization.DataCenterPlanOptimizer;
import io.hetu.core.plugin.datacenter.pagesource.DataCenterPageSourceProvider;
import io.prestosql.spi.ConnectorPlanOptimizer;
import io.prestosql.spi.connector.CachedConnectorMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorPlanOptimizerProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import okhttp3.OkHttpClient;

public class DataCenterConnector
implements Connector {
    private static final Logger log = Logger.get(DataCenterConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ConnectorMetadata metadata;
    private final DataCenterSplitManager splitManager;
    private final DataCenterPageSourceProvider pageSourceProvider;
    private final DataCenterClient dataCenterClient;
    private final OkHttpClient httpClient;
    private final ConnectorPlanOptimizer planOptimizer;

    @Inject
    public DataCenterConnector(LifeCycleManager lifeCycleManager, DataCenterConfig dataCenterConfig, TypeManager typeManager, DataCenterPlanOptimizer planOptimizer) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.httpClient = DataCenterStatementClientFactory.newHttpClient(dataCenterConfig);
        this.dataCenterClient = new DataCenterClient(dataCenterConfig, this.httpClient, typeManager);
        this.splitManager = new DataCenterSplitManager(dataCenterConfig, this.dataCenterClient);
        this.pageSourceProvider = new DataCenterPageSourceProvider(dataCenterConfig, this.httpClient, typeManager);
        this.planOptimizer = planOptimizer;
        this.metadata = dataCenterConfig.isMetadataCacheEnabled() ? new CachedConnectorMetadata((ConnectorMetadata)new DataCenterMetadata(this.dataCenterClient, dataCenterConfig), dataCenterConfig.getMetadataCacheTtl(), dataCenterConfig.getMetadataCacheMaximumSize()) : new DataCenterMetadata(this.dataCenterClient, dataCenterConfig);
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return new ConnectorPlanOptimizerProvider(){

            public Set<ConnectorPlanOptimizer> getLogicalPlanOptimizers() {
                return ImmutableSet.of((Object)DataCenterConnector.this.planOptimizer);
            }

            public Set<ConnectorPlanOptimizer> getPhysicalPlanOptimizers() {
                return ImmutableSet.of();
            }
        };
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean isReadOnly) {
        return DataCenterTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public Collection<String> getCatalogs(String user, Map<String, String> extraCredentials) {
        return this.dataCenterClient.getCatalogNames();
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

