/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.expressions;

import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.function.FunctionMetadata;
import io.prestosql.spi.function.FunctionMetadataManager;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.StandardFunctionResolution;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.ConstantExpression;
import io.prestosql.spi.relation.DeterminismEvaluator;
import io.prestosql.spi.relation.InputReferenceExpression;
import io.prestosql.spi.relation.LambdaDefinitionExpression;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.relation.RowExpressionVisitor;
import io.prestosql.spi.relation.SpecialForm;
import io.prestosql.spi.relation.VariableReferenceExpression;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class LogicalRowExpressions {
    public static final ConstantExpression TRUE_CONSTANT = new ConstantExpression((Object)true, (Type)BooleanType.BOOLEAN);
    public static final ConstantExpression FALSE_CONSTANT = new ConstantExpression((Object)false, (Type)BooleanType.BOOLEAN);
    private static final int ELIMINATE_COMMON_SIZE_LIMIT = 10000;
    private final DeterminismEvaluator determinismEvaluator;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;

    public LogicalRowExpressions(DeterminismEvaluator determinismEvaluator, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager) {
        this.determinismEvaluator = determinismEvaluator;
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
    }

    public static RowExpression or(RowExpression ... expressions) {
        return LogicalRowExpressions.or(Arrays.asList(expressions));
    }

    public static RowExpression or(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialForm.Form.OR, expressions);
    }

    public static List<RowExpression> extractPredicates(RowExpression expression) {
        SpecialForm.Form form;
        if (expression instanceof SpecialForm && ((form = ((SpecialForm)expression).getForm()) == SpecialForm.Form.AND || form == SpecialForm.Form.OR)) {
            return LogicalRowExpressions.extractPredicates(form, expression);
        }
        return Collections.singletonList(expression);
    }

    public RowExpression pushNegationToLeaves(RowExpression expression) {
        return (RowExpression)expression.accept((RowExpressionVisitor)new PushNegationVisitor(), null);
    }

    public RowExpression convertToConjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialForm.Form.AND);
    }

    public RowExpression convertToDisjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialForm.Form.OR);
    }

    public RowExpression minimalNormalForm(RowExpression expression) {
        RowExpression conjunctiveNormalForm = this.convertToConjunctiveNormalForm(expression);
        RowExpression disjunctiveNormalForm = this.convertToDisjunctiveNormalForm(expression);
        return this.numOfClauses(conjunctiveNormalForm) > this.numOfClauses(disjunctiveNormalForm) ? disjunctiveNormalForm : conjunctiveNormalForm;
    }

    public RowExpression convertToNormalForm(RowExpression expression, SpecialForm.Form clauseJoiner) {
        return (RowExpression)this.pushNegationToLeaves(expression).accept((RowExpressionVisitor)new ConvertNormalFormVisitor(), (Object)LogicalRowExpressions.rootContext(clauseJoiner));
    }

    public RowExpression filterDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, arg_0 -> ((DeterminismEvaluator)this.determinismEvaluator).isDeterministic(arg_0));
    }

    public RowExpression filterNonDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, predicate -> !this.determinismEvaluator.isDeterministic(predicate));
    }

    public RowExpression filterConjuncts(RowExpression expression, Predicate<RowExpression> predicate) {
        List<RowExpression> conjuncts = LogicalRowExpressions.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return this.combineConjuncts(conjuncts);
    }

    public RowExpression combineConjuncts(RowExpression ... expressions) {
        return this.combineConjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineConjuncts(Collection<RowExpression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> conjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)TRUE_CONSTANT)).collect(Collectors.toList());
        conjuncts = this.removeDuplicates(conjuncts);
        if (conjuncts.contains(FALSE_CONSTANT)) {
            return FALSE_CONSTANT;
        }
        return LogicalRowExpressions.and(conjuncts);
    }

    private List<RowExpression> removeDuplicates(List<RowExpression> expressions) {
        HashSet<RowExpression> seen = new HashSet<RowExpression>();
        ArrayList<RowExpression> result = new ArrayList<RowExpression>();
        for (RowExpression expression : expressions) {
            if (LogicalRowExpressions.isDeterministic(expression)) {
                RowExpression expressionFlip = this.flipOperatorFunctionWithOneVarOneConstant(expression);
                if (seen.contains(expressionFlip)) continue;
                result.add(expressionFlip);
                seen.add(expressionFlip);
                continue;
            }
            result.add(expression);
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isDeterministic(RowExpression call) {
        if (call instanceof CallExpression) {
            ImmutableSet functions = ImmutableSet.of((Object)"rand", (Object)"random", (Object)"shuffle", (Object)"uuid");
            return !functions.contains(((CallExpression)call).getDisplayName().toLowerCase(Locale.ENGLISH));
        }
        return true;
    }

    public static boolean isDeterministic(DeterminismEvaluator evaluator, RowExpression call) {
        return evaluator.isDeterministic(call);
    }

    public RowExpression flipOperatorFunctionWithOneVarOneConstant(RowExpression expressions) {
        CallExpression call;
        FunctionMetadata functionMetadata;
        if (expressions instanceof CallExpression && (functionMetadata = this.functionMetadataManager.getFunctionMetadata((call = (CallExpression)expressions).getFunctionHandle())).getOperatorType().isPresent() && ((OperatorType)functionMetadata.getOperatorType().get()).isComparisonOperator() && call.getArguments().get(1) instanceof VariableReferenceExpression && call.getArguments().get(0) instanceof ConstantExpression) {
            OperatorType operator;
            switch ((OperatorType)functionMetadata.getOperatorType().get()) {
                case LESS_THAN: {
                    operator = OperatorType.GREATER_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    operator = OperatorType.GREATER_THAN_OR_EQUAL;
                    break;
                }
                case GREATER_THAN: {
                    operator = OperatorType.LESS_THAN;
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    operator = OperatorType.LESS_THAN_OR_EQUAL;
                    break;
                }
                case IS_DISTINCT_FROM: {
                    operator = OperatorType.IS_DISTINCT_FROM;
                    break;
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    operator = (OperatorType)functionMetadata.getOperatorType().get();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported or is not comparison operator: %s", functionMetadata.getOperatorType().get()));
                }
            }
            ArrayList arguments = new ArrayList();
            arguments.add(call.getArguments().get(1));
            arguments.add(call.getArguments().get(0));
            return new CallExpression(operator.name(), this.functionResolution.comparisonFunction(operator, ((RowExpression)call.getArguments().get(1)).getType(), ((RowExpression)call.getArguments().get(0)).getType()), call.getType(), arguments, Optional.empty());
        }
        return expressions;
    }

    public static List<RowExpression> extractConjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialForm.Form.AND, expression);
    }

    public static List<RowExpression> extractPredicates(SpecialForm.Form form, RowExpression expression) {
        if (expression instanceof SpecialForm && ((SpecialForm)expression).getForm() == form) {
            SpecialForm specialFormExpression = (SpecialForm)expression;
            if (specialFormExpression.getArguments().size() != 2) {
                throw new IllegalStateException("logical binary expression requires exactly 2 operands");
            }
            ArrayList<RowExpression> predicates = new ArrayList<RowExpression>();
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, (RowExpression)specialFormExpression.getArguments().get(0)));
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, (RowExpression)specialFormExpression.getArguments().get(1)));
            return Collections.unmodifiableList(predicates);
        }
        return Collections.singletonList(expression);
    }

    public static List<RowExpression> extractAllPredicates(RowExpression expression) {
        ArrayList<RowExpression> predicates = new ArrayList<RowExpression>();
        if (expression instanceof SpecialForm && (((SpecialForm)expression).getForm() == SpecialForm.Form.AND || ((SpecialForm)expression).getForm() == SpecialForm.Form.OR)) {
            if (((SpecialForm)expression).getArguments().size() != 2) {
                throw new IllegalStateException("logical binary expression requires exactly 2 operands");
            }
        } else {
            return Arrays.asList(expression);
        }
        predicates.addAll(LogicalRowExpressions.extractAllPredicates((RowExpression)((SpecialForm)expression).getArguments().get(0)));
        predicates.addAll(LogicalRowExpressions.extractAllPredicates((RowExpression)((SpecialForm)expression).getArguments().get(1)));
        return predicates;
    }

    public RowExpression combinePredicates(SpecialForm.Form form, Collection<RowExpression> expressions) {
        if (form == SpecialForm.Form.AND) {
            return this.combineConjuncts(expressions);
        }
        return this.combineDisjuncts(expressions);
    }

    public RowExpression combineDisjuncts(Collection<RowExpression> expressions) {
        return this.combineDisjunctsWithDefault(expressions, (RowExpression)FALSE_CONSTANT);
    }

    public RowExpression combineDisjunctsWithDefault(Collection<RowExpression> expressions, RowExpression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> disjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)FALSE_CONSTANT)).collect(Collectors.toList());
        disjuncts = this.removeDuplicates(disjuncts);
        if (disjuncts.contains(TRUE_CONSTANT)) {
            return TRUE_CONSTANT;
        }
        return disjuncts.isEmpty() ? emptyDefault : LogicalRowExpressions.or(disjuncts);
    }

    public static List<RowExpression> extractDisjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialForm.Form.OR, expression);
    }

    private static ConvertNormalFormVisitorContext rootContext(SpecialForm.Form clauseJoiner) {
        return new ConvertNormalFormVisitorContext(clauseJoiner, 0);
    }

    private boolean isConjunctionOrDisjunction(RowExpression expression) {
        if (expression instanceof SpecialForm) {
            SpecialForm.Form form = ((SpecialForm)expression).getForm();
            return form == SpecialForm.Form.AND || form == SpecialForm.Form.OR;
        }
        return false;
    }

    private boolean isNegationExpression(RowExpression expression) {
        return expression instanceof CallExpression && ((CallExpression)expression).getFunctionHandle().equals(this.functionResolution.notFunction());
    }

    private boolean isComparisonExpression(RowExpression expression) {
        return expression instanceof CallExpression && this.functionResolution.isComparisonFunction(((CallExpression)expression).getFunctionHandle());
    }

    private List<List<RowExpression>> getGroupedClauses(SpecialForm expression) {
        return LogicalRowExpressions.extractPredicates(expression.getForm(), (RowExpression)expression).stream().map(LogicalRowExpressions::extractPredicates).collect(Collectors.toList());
    }

    private int numOfClauses(RowExpression expression) {
        if (expression instanceof SpecialForm) {
            return this.getGroupedClauses((SpecialForm)expression).stream().mapToInt(List::size).sum();
        }
        return 1;
    }

    private List<List<RowExpression>> eliminateCommonPredicates(List<List<RowExpression>> groupedClauses) {
        if (groupedClauses.size() < 2) {
            return groupedClauses;
        }
        int[] reduceTo = IntStream.range(0, groupedClauses.size()).toArray();
        for (int i = 0; i < groupedClauses.size(); ++i) {
            if (!groupedClauses.get(i).stream().allMatch(arg_0 -> ((DeterminismEvaluator)this.determinismEvaluator).isDeterministic(arg_0))) continue;
            for (int j = 0; j < groupedClauses.size(); ++j) {
                if (LogicalRowExpressions.isSuperSet((Collection)groupedClauses.get(reduceTo[i]), (Collection)groupedClauses.get(j))) {
                    reduceTo[i] = j;
                    continue;
                }
                if (!LogicalRowExpressions.isSameSet((Collection)groupedClauses.get(reduceTo[i]), (Collection)groupedClauses.get(j))) continue;
                reduceTo[i] = Math.min(reduceTo[i], j);
            }
        }
        return Collections.unmodifiableList(Arrays.stream(reduceTo).distinct().boxed().map(groupedClauses::get).collect(Collectors.toList()));
    }

    private List<List<RowExpression>> extractCommonPredicates(SpecialForm.Form rootClauseJoiner, List<List<RowExpression>> groupedPredicates) {
        if (groupedPredicates.isEmpty()) {
            return null;
        }
        LinkedHashSet commonPredicates = new LinkedHashSet(groupedPredicates.get(0));
        for (int i = 1; i < groupedPredicates.size(); ++i) {
            commonPredicates.retainAll((Collection)groupedPredicates.get(i));
        }
        if (commonPredicates.isEmpty()) {
            return null;
        }
        ArrayList<RowExpression> remainingPredicates = new ArrayList<RowExpression>();
        for (List<RowExpression> group : groupedPredicates) {
            List<RowExpression> remaining = group.stream().filter(predicate -> !commonPredicates.contains(predicate)).collect(Collectors.toList());
            remainingPredicates.add(this.combinePredicates(LogicalRowExpressions.flip(rootClauseJoiner), remaining));
        }
        return Stream.concat(commonPredicates.stream().map(predicate -> Collections.singletonList(predicate)), Stream.of(remainingPredicates)).collect(Collectors.toList());
    }

    private RowExpression combineGroupedClauses(SpecialForm.Form clauseJoiner, List<List<RowExpression>> nestedPredicates) {
        return this.combinePredicates(clauseJoiner, nestedPredicates.stream().map(predicate -> this.combinePredicates(LogicalRowExpressions.flip(clauseJoiner), (Collection<RowExpression>)predicate)).collect(Collectors.toList()));
    }

    private static List<List<RowExpression>> crossProduct(List<List<RowExpression>> groupedPredicates) {
        LogicalRowExpressions.checkArgument(groupedPredicates.size() > 0, "Must contains more than one child", new Object[0]);
        List<List<RowExpression>> result = groupedPredicates.get(0).stream().map(Collections::singletonList).collect(Collectors.toList());
        for (int i = 1; i < groupedPredicates.size(); ++i) {
            result = LogicalRowExpressions.crossProduct(result, groupedPredicates.get(i));
        }
        return result;
    }

    private static List<List<RowExpression>> crossProduct(List<List<RowExpression>> previousCrossProduct, List<RowExpression> clauses) {
        ArrayList<List<RowExpression>> result = new ArrayList<List<RowExpression>>();
        for (List<RowExpression> previousClauses : previousCrossProduct) {
            for (RowExpression newClause : clauses) {
                ArrayList<RowExpression> newClauses = new ArrayList<RowExpression>(previousClauses);
                newClauses.add(newClause);
                result.add(newClauses);
            }
        }
        return result;
    }

    private static SpecialForm.Form flip(SpecialForm.Form binaryLogicalOperation) {
        switch (binaryLogicalOperation) {
            case AND: {
                return SpecialForm.Form.OR;
            }
            case OR: {
                return SpecialForm.Form.AND;
            }
        }
        throw new UnsupportedOperationException("Invalid binary logical operation: " + binaryLogicalOperation);
    }

    private Optional<OperatorType> getOperator(RowExpression expression) {
        if (expression instanceof CallExpression) {
            return this.functionMetadataManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getOperatorType();
        }
        return Optional.empty();
    }

    private RowExpression notCallExpression(RowExpression argument) {
        return new CallExpression("not", this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, Collections.singletonList(argument), Optional.empty());
    }

    private static OperatorType negate(OperatorType operator) {
        switch (operator) {
            case EQUAL: {
                return OperatorType.NOT_EQUAL;
            }
            case NOT_EQUAL: {
                return OperatorType.EQUAL;
            }
            case GREATER_THAN: {
                return OperatorType.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return OperatorType.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return OperatorType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return OperatorType.LESS_THAN;
            }
        }
        return null;
    }

    private static void checkArgument(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, arguments));
        }
    }

    private static <T> boolean isSuperSet(Collection<T> a, Collection<T> b) {
        return a.size() > b.size() && a.containsAll(b);
    }

    private static <T> boolean isSameSet(Collection<T> a, Collection<T> b) {
        return a.size() == b.size() && a.containsAll(b) && b.containsAll(a);
    }

    public static RowExpression and(RowExpression ... expressions) {
        return LogicalRowExpressions.and(Arrays.asList(expressions));
    }

    public static RowExpression and(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialForm.Form.AND, expressions);
    }

    public static RowExpression binaryExpression(SpecialForm.Form form, Collection<RowExpression> expressions) {
        Objects.requireNonNull(form, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (form) {
                case AND: {
                    return TRUE_CONSTANT;
                }
                case OR: {
                    return FALSE_CONSTANT;
                }
            }
            throw new IllegalArgumentException("Unsupported binary expression operator");
        }
        ArrayDeque<Object> queue = new ArrayDeque<RowExpression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<Object> buffer = new ArrayDeque<Object>();
            while (queue.size() >= 2) {
                List<RowExpression> arguments = Arrays.asList((RowExpression)queue.remove(), (RowExpression)queue.remove());
                buffer.add(new SpecialForm(form, (Type)BooleanType.BOOLEAN, arguments));
            }
            if (!queue.isEmpty()) {
                buffer.add(queue.remove());
            }
            queue = buffer;
        }
        return (RowExpression)queue.remove();
    }

    private class ConvertNormalFormVisitor
    implements RowExpressionVisitor<RowExpression, ConvertNormalFormVisitorContext> {
        private ConvertNormalFormVisitor() {
        }

        public RowExpression visitSpecialForm(SpecialForm specialForm, ConvertNormalFormVisitorContext context) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction((RowExpression)specialForm)) {
                return specialForm;
            }
            RowExpression rewritten = LogicalRowExpressions.this.combinePredicates(specialForm.getForm(), LogicalRowExpressions.extractPredicates(specialForm.getForm(), (RowExpression)specialForm).stream().map(subPredicate -> (RowExpression)subPredicate.accept((RowExpressionVisitor)this, (Object)context.childContext())).collect(Collectors.toList()));
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(rewritten)) {
                return rewritten;
            }
            SpecialForm rewrittenSpecialForm = (SpecialForm)rewritten;
            SpecialForm.Form expressionClauseJoiner = rewrittenSpecialForm.getForm();
            List groupedClauses = LogicalRowExpressions.this.getGroupedClauses(rewrittenSpecialForm);
            if (groupedClauses.stream().mapToInt(List::size).sum() > 10000) {
                return rewritten;
            }
            List groupedClausesWithFlippedJoiner = LogicalRowExpressions.this.extractCommonPredicates(expressionClauseJoiner, groupedClauses = LogicalRowExpressions.this.eliminateCommonPredicates(groupedClauses));
            if (groupedClausesWithFlippedJoiner != null) {
                groupedClauses = groupedClausesWithFlippedJoiner;
                expressionClauseJoiner = LogicalRowExpressions.flip(expressionClauseJoiner);
            }
            int numClauses = groupedClauses.stream().mapToInt(List::size).sum();
            int numClausesProducedByDistributiveLaw = groupedClauses.size();
            for (List group : groupedClauses) {
                if (context.depth <= 0 && (numClausesProducedByDistributiveLaw *= group.size()) <= numClauses * 2) continue;
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            if (numClausesProducedByDistributiveLaw == numClauses) {
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            boolean deterministic = groupedClauses.stream().flatMap(Collection::stream).allMatch(arg_0 -> ((DeterminismEvaluator)LogicalRowExpressions.this.determinismEvaluator).isDeterministic(arg_0));
            if (expressionClauseJoiner == context.expectedClauseJoiner || !deterministic) {
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            groupedClauses = LogicalRowExpressions.crossProduct(groupedClauses);
            return LogicalRowExpressions.this.combineGroupedClauses(context.expectedClauseJoiner, groupedClauses);
        }

        public RowExpression visitCall(CallExpression call, ConvertNormalFormVisitorContext context) {
            return call;
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, ConvertNormalFormVisitorContext context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, ConvertNormalFormVisitorContext context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, ConvertNormalFormVisitorContext context) {
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, ConvertNormalFormVisitorContext context) {
            return reference;
        }
    }

    private static class ConvertNormalFormVisitorContext {
        private final SpecialForm.Form expectedClauseJoiner;
        private final int depth;

        public ConvertNormalFormVisitorContext(SpecialForm.Form expectedClauseJoiner, int depth) {
            this.expectedClauseJoiner = expectedClauseJoiner;
            this.depth = depth;
        }

        public ConvertNormalFormVisitorContext childContext() {
            return new ConvertNormalFormVisitorContext(this.expectedClauseJoiner, this.depth + 1);
        }
    }

    private final class PushNegationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private PushNegationVisitor() {
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            if (!LogicalRowExpressions.this.isNegationExpression((RowExpression)call)) {
                return call;
            }
            LogicalRowExpressions.checkArgument(call.getArguments().size() == 1, "Not expression should have exactly one argument", new Object[0]);
            RowExpression argument = (RowExpression)call.getArguments().get(0);
            if (LogicalRowExpressions.this.isNegationExpression(argument)) {
                return (RowExpression)((RowExpression)((CallExpression)argument).getArguments().get(0)).accept((RowExpressionVisitor)new PushNegationVisitor(), null);
            }
            if (LogicalRowExpressions.this.isComparisonExpression(argument)) {
                return this.negateComparison((CallExpression)argument);
            }
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(argument)) {
                return call;
            }
            SpecialForm specialForm = (SpecialForm)argument;
            RowExpression left = (RowExpression)specialForm.getArguments().get(0);
            RowExpression right = (RowExpression)specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialForm.Form.AND) {
                return LogicalRowExpressions.or((RowExpression)LogicalRowExpressions.this.notCallExpression(left).accept((RowExpressionVisitor)new PushNegationVisitor(), null), (RowExpression)LogicalRowExpressions.this.notCallExpression(right).accept((RowExpressionVisitor)this, null));
            }
            return LogicalRowExpressions.and((RowExpression)LogicalRowExpressions.this.notCallExpression(left).accept((RowExpressionVisitor)new PushNegationVisitor(), null), (RowExpression)LogicalRowExpressions.this.notCallExpression(right).accept((RowExpressionVisitor)this, null));
        }

        private RowExpression negateComparison(CallExpression expression) {
            OperatorType newOperator = LogicalRowExpressions.negate(LogicalRowExpressions.this.getOperator((RowExpression)expression).orElse(null));
            if (newOperator == null) {
                return new CallExpression("not", LogicalRowExpressions.this.functionResolution.notFunction(), (Type)BooleanType.BOOLEAN, Collections.singletonList(expression), Optional.empty());
            }
            LogicalRowExpressions.checkArgument(expression.getArguments().size() == 2, "Comparison expression must have exactly two arguments", new Object[0]);
            RowExpression left = (RowExpression)((RowExpression)expression.getArguments().get(0)).accept((RowExpressionVisitor)this, null);
            RowExpression right = (RowExpression)((RowExpression)expression.getArguments().get(1)).accept((RowExpressionVisitor)this, null);
            return new CallExpression(newOperator.name(), LogicalRowExpressions.this.functionResolution.comparisonFunction(newOperator, left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, Arrays.asList(left, right), Optional.empty());
        }

        public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction((RowExpression)specialForm)) {
                return specialForm;
            }
            RowExpression left = (RowExpression)specialForm.getArguments().get(0);
            RowExpression right = (RowExpression)specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialForm.Form.AND) {
                return LogicalRowExpressions.and((RowExpression)left.accept((RowExpressionVisitor)this, null), (RowExpression)right.accept((RowExpressionVisitor)this, null));
            }
            return LogicalRowExpressions.or((RowExpression)left.accept((RowExpressionVisitor)this, null), (RowExpression)right.accept((RowExpressionVisitor)this, null));
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }
    }
}

