/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall.functions.config;

import io.prestosql.configmanager.ConfigSupplier;
import io.prestosql.sql.builder.functioncall.ConfigFunctionParser;
import io.prestosql.sql.builder.functioncall.FunctionCallArgsPackage;
import io.prestosql.sql.builder.functioncall.functions.FunctionCallRewriter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DefaultConnectorConfigFunctionRewriter
implements FunctionCallRewriter {
    protected static volatile DefaultConnectorConfigFunctionRewriter instance;
    private BiFunction<FunctionCallArgsPackage, String, String> resultFunctionStringBuilder;
    private Function<FunctionCallArgsPackage, String> propertyNameBuilder;
    private String connectorName;
    private ConfigSupplier configSupplier;

    public DefaultConnectorConfigFunctionRewriter(String connectorName, ConfigSupplier configSupplier) {
        this(connectorName, configSupplier, ConfigFunctionParser::baseFunctionArgsToConfigPropertyName, ConfigFunctionParser::baseConfigPropertyValueToFunctionPushDownString);
    }

    private DefaultConnectorConfigFunctionRewriter(String connectorName, ConfigSupplier configSupplier, Function<FunctionCallArgsPackage, String> propertyNameBuilder, BiFunction<FunctionCallArgsPackage, String, String> resultFunctionStringBuilder) {
        this.connectorName = Objects.requireNonNull(connectorName, "versionName is null");
        this.propertyNameBuilder = Objects.requireNonNull(propertyNameBuilder, "signatureBuilder is null");
        this.resultFunctionStringBuilder = Objects.requireNonNull(resultFunctionStringBuilder, "argsFunction is null...");
        this.configSupplier = Objects.requireNonNull(configSupplier, "configSupplier is null");
    }

    @Override
    public String rewriteFunctionCall(FunctionCallArgsPackage functionCallArgsPackage) {
        String functionPropertyName = this.propertyNameBuilder.apply(functionCallArgsPackage);
        Optional<String> propertyValue = this.configSupplier.getConfigValue(functionPropertyName);
        return propertyValue.map(s -> this.resultFunctionStringBuilder.apply(functionCallArgsPackage, (String)s)).orElse(null);
    }
}

