/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall;

import io.prestosql.spi.sql.expression.QualifiedName;
import io.prestosql.sql.builder.functioncall.FunctionCallArgsPackage;
import io.prestosql.sql.builder.functioncall.functions.FunctionCallRewriter;
import io.prestosql.sql.builder.functioncall.functions.config.DefaultConnectorConfigFunctionRewriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class FunctionWriterManager {
    private Map<String, FunctionCallRewriter> rewriteFunctionMap = new ConcurrentHashMap<String, FunctionCallRewriter>(Collections.emptyMap());
    private DefaultConnectorConfigFunctionRewriter connectorConfigFunctionRewriter;
    private Function<FunctionCallArgsPackage, String> argsFunction;
    private String connectorName;
    private String versionName;

    private FunctionWriterManager(String connectorName, String versionName, Map<String, FunctionCallRewriter> functionCallRewriterMap, DefaultConnectorConfigFunctionRewriter connectorConfigFunctionRewriter, Function<FunctionCallArgsPackage, String> functionSignatureBuild) {
        this.connectorName = connectorName;
        this.versionName = versionName;
        this.rewriteFunctionMap.putAll(functionCallRewriterMap);
        this.addConfigFunctionRewriter(connectorConfigFunctionRewriter);
        this.argsFunction = functionSignatureBuild;
    }

    protected FunctionWriterManager(String connectorName, String versionName, Map<String, FunctionCallRewriter> functionCallRewriterMap, DefaultConnectorConfigFunctionRewriter connectorConfigFunctionRewriter) {
        this(connectorName, versionName, functionCallRewriterMap, connectorConfigFunctionRewriter, FunctionCallArgsPackage::defaultBuildFunctionSignature);
    }

    private final boolean addUserDefineFunctionSupport(String functionSignature, FunctionCallRewriter functionCallRewriter) {
        if (this.rewriteFunctionMap.containsKey(functionSignature)) {
            return false;
        }
        this.rewriteFunctionMap.put(functionSignature, functionCallRewriter);
        return true;
    }

    private final void addConfigFunctionRewriter(DefaultConnectorConfigFunctionRewriter connectorConfigFunctionRewriter) {
        Objects.requireNonNull(connectorConfigFunctionRewriter);
        this.connectorConfigFunctionRewriter = connectorConfigFunctionRewriter;
    }

    public final String getFunctionRewriteResult(QualifiedName name, boolean isDistinct, List<String> argumentsList, Optional<String> orderBy, Optional<String> filter, Optional<String> window) {
        FunctionCallArgsPackage functionCallArgsPackage = new FunctionCallArgsPackage(name, isDistinct, argumentsList, orderBy, filter, window);
        String functionSignature = this.argsFunction.apply(functionCallArgsPackage);
        FunctionCallRewriter functionCallRewriter = this.rewriteFunctionMap.getOrDefault(functionSignature, null);
        Optional<Object> result = Optional.empty();
        if (functionCallRewriter != null) {
            result = Optional.ofNullable(functionCallRewriter.rewriteFunctionCall(functionCallArgsPackage));
        }
        if (!result.isPresent() && this.connectorConfigFunctionRewriter != null) {
            result = Optional.ofNullable(this.connectorConfigFunctionRewriter.rewriteFunctionCall(functionCallArgsPackage));
        }
        if (result.isPresent()) {
            return (String)result.get();
        }
        String exceptionStr = this.connectorName + " Connector does not support function call of " + FunctionCallArgsPackage.defaultBuildFunctionSignature(functionCallArgsPackage);
        throw new UnsupportedOperationException(exceptionStr);
    }
}

