/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.splitmanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.splitmanager.DataSourceSplitSource;
import io.prestosql.plugin.splitmanager.SplitStatLog;
import io.prestosql.plugin.splitmanager.StepCalcManager;
import io.prestosql.plugin.splitmanager.TableSplitConfig;
import io.prestosql.plugin.splitmanager.TableSplitUtil;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.FixedSplitSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DataSourceTableSplitManager {
    private static final Logger log = Logger.get(DataSourceTableSplitManager.class);
    private boolean enableTableSplit;
    private Map<String, TableSplitConfig> tableSplitsMap = new HashMap<String, TableSplitConfig>();
    private StepCalcManager stepCalcManager;
    private JdbcClient jdbcClient;

    @Inject
    public DataSourceTableSplitManager(BaseJdbcConfig config, JdbcClient jdbcClient, NodeManager nodeManager) {
        this.enableTableSplit = config.getTableSplitEnable();
        this.jdbcClient = jdbcClient;
        if (this.enableTableSplit && nodeManager.getCurrentNode().isCoordinator()) {
            List<TableSplitConfig> splitConfigs = this.loadTableSplitFiledConfig(config.getTableSplitFields());
            this.tableSplitsMap = splitConfigs.stream().collect(Collectors.toMap(p -> TableSplitUtil.generateTableFullName(p.getCatalogName(), p.getSchemaName(), p.getTableName()), Function.identity()));
            this.stepCalcManager = new StepCalcManager(config.getTableSplitStepCalcRefreshInterval(), config.getTableSplitStepCalcCalcThreads(), splitConfigs);
            Thread stepCalcThread = new Thread(this.stepCalcManager);
            stepCalcThread.setName("step calc thread");
            stepCalcThread.setDaemon(true);
            stepCalcThread.start();
            this.stepCalcManager.start();
        }
    }

    public ConnectorSplitSource getSplits(JdbcIdentity identity, JdbcTableHandle tableHandle) {
        if (this.enableTableSplit) {
            return this.getTableSplits(identity, tableHandle);
        }
        return this.getFixedSplitSource(tableHandle);
    }

    private List<TableSplitConfig> loadTableSplitFiledConfig(String jsonConfigContext) {
        if (Strings.isNullOrEmpty((String)jsonConfigContext)) {
            return new ArrayList<TableSplitConfig>();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (List)objectMapper.readValue(jsonConfigContext, (TypeReference)new TypeReference<List<TableSplitConfig>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("loading table split field, error info:" + e.getMessage());
            return new ArrayList<TableSplitConfig>();
        }
    }

    private void handleSplitStatic(JdbcIdentity identity, List<JdbcSplit> jdbcSplitList) {
        List<SplitStatLog> splitStatLogList = this.jdbcClient.getSplitStatic(identity, jdbcSplitList);
        this.stepCalcManager.commitSplitStatLog(splitStatLogList);
    }

    public TableSplitConfig getTableSplitConfig(JdbcTableHandle jdbcTableHandle) {
        if (null == jdbcTableHandle || !this.enableTableSplit) {
            return null;
        }
        return this.tableSplitsMap.get(TableSplitUtil.generateTableFullName(jdbcTableHandle.getCatalogName(), jdbcTableHandle.getSchemaName(), jdbcTableHandle.getTableName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectorSplitSource getTableSplits(final JdbcIdentity identity, JdbcTableHandle jdbcTableHandle) {
        final ArrayList<JdbcSplit> jdbcSplitsList = new ArrayList<JdbcSplit>();
        TableSplitConfig splitConfig = this.tableSplitsMap.get(TableSplitUtil.generateTableFullName(jdbcTableHandle.getCatalogName(), jdbcTableHandle.getSchemaName(), jdbcTableHandle.getTableName()));
        if (splitConfig == null) {
            return this.getFixedSplitSource(jdbcTableHandle);
        }
        if (splitConfig.getSplitCount() == null) return this.getFixedSplitSource(jdbcTableHandle);
        if (Strings.isNullOrEmpty((String)splitConfig.getSplitField())) return this.getFixedSplitSource(jdbcTableHandle);
        if (splitConfig.getSplitCount() <= 1) {
            return this.getFixedSplitSource(jdbcTableHandle);
        }
        if (!splitConfig.isTableSplitFieldValid()) {
            log.warn("Table(%s) split field(%s) NOT integer like value type.", new Object[]{TableSplitUtil.generateTableFullName(jdbcTableHandle.getCatalogName(), jdbcTableHandle.getSchemaName(), jdbcTableHandle.getTableName()), splitConfig.getSplitField()});
            return this.getFixedSplitSource(jdbcTableHandle);
        }
        long timeStamp = System.nanoTime();
        if (splitConfig.isCalcStepEnable()) {
            List<SplitStatLog> splitLogs;
            try {
                splitLogs = this.stepCalcManager.getAdjustSplitList(jdbcTableHandle.getCatalogName(), jdbcTableHandle.getSchemaName(), jdbcTableHandle.getTableName());
                if (null == splitLogs) {
                    splitLogs = new ArrayList<SplitStatLog>();
                }
            }
            catch (PrestoException e) {
                log.error("Get table split from dynamic step calc manager failed, error info:" + e.getMessage());
                return this.getFixedSplitSource(jdbcTableHandle);
            }
            for (SplitStatLog splitLog : splitLogs) {
                String splitPart = splitConfig.getSplitField() + " > " + splitLog.getBeginIndex() + " and " + splitConfig.getSplitField() + " <= " + splitLog.getEndIndex();
                JdbcSplit jdbcSplit = new JdbcSplit(splitLog.getCatalogName(), splitLog.getSchemaName(), splitLog.getTableName(), splitConfig.getSplitField(), splitLog.getBeginIndex().toString(), splitLog.getEndIndex().toString(), timeStamp, splitConfig.getSplitCount(), Optional.of(splitPart));
                jdbcSplitsList.add(jdbcSplit);
            }
        }
        if (jdbcSplitsList == null || jdbcSplitsList.isEmpty()) {
            Long[] fieldMinAndMaxValue = new Long[2];
            try (Connection connection = this.jdbcClient.getConnection(identity, (JdbcSplit)null);){
                fieldMinAndMaxValue = this.jdbcClient.getSplitFieldMinAndMaxValue(splitConfig, connection, jdbcTableHandle);
                if (fieldMinAndMaxValue == null || fieldMinAndMaxValue[0].equals(fieldMinAndMaxValue[1])) {
                    FixedSplitSource fixedSplitSource = this.getFixedSplitSource(jdbcTableHandle);
                    return fixedSplitSource;
                }
            }
            catch (SQLException e) {
                return this.getFixedSplitSource(jdbcTableHandle);
            }
            this.splitTable(fieldMinAndMaxValue, jdbcTableHandle, jdbcSplitsList, splitConfig, timeStamp);
        }
        if (!splitConfig.isCalcStepEnable()) return new DataSourceSplitSource(jdbcSplitsList);
        if (jdbcSplitsList.size() <= 1) return new DataSourceSplitSource(jdbcSplitsList);
        Thread collectStaticLogs = new Thread(new Runnable(){

            @Override
            public void run() {
                DataSourceTableSplitManager.this.handleSplitStatic(identity, jdbcSplitsList);
            }
        });
        collectStaticLogs.start();
        return new DataSourceSplitSource(jdbcSplitsList);
    }

    private FixedSplitSource getFixedSplitSource(JdbcTableHandle tableHandle) {
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)new JdbcSplit(tableHandle.getCatalogName(), tableHandle.getSchemaName(), tableHandle.getTableName(), "", "", "", System.nanoTime(), 1, Optional.empty())));
    }

    private void addJdbcSplit(JdbcTableHandle tableHandle, List<JdbcSplit> builder, String[] splitInfo, long timeStamp, int scanNodes, TableSplitConfig config) {
        JdbcSplit jdbcSplit = new JdbcSplit(tableHandle.getCatalogName(), tableHandle.getSchemaName(), tableHandle.getTableName(), config.getSplitField(), splitInfo[1], splitInfo[2], timeStamp, scanNodes, Optional.of(splitInfo[0]));
        builder.add(jdbcSplit);
    }

    private void splitTable(Long[] fieldMinAndMaxValue, JdbcTableHandle jdbcTableHandle, List<JdbcSplit> splits, TableSplitConfig config, long timeStamp) {
        int scanNodes = config.getSplitCount();
        long tableTotalRecords = fieldMinAndMaxValue[0] - fieldMinAndMaxValue[1] + 1L;
        long targetChunkSize = (long)Math.ceil((double)tableTotalRecords * 1.0 / (double)scanNodes);
        long chunkOffset = 0L;
        long autoIncrementOffset = 0L;
        while (chunkOffset < tableTotalRecords) {
            long chunkLength = Math.min(targetChunkSize, tableTotalRecords - chunkOffset);
            if (chunkOffset == 0L) {
                autoIncrementOffset = fieldMinAndMaxValue[1];
            }
            String[] splitInfo = this.getSplitInfo(chunkOffset, autoIncrementOffset - 1L, fieldMinAndMaxValue, chunkLength, tableTotalRecords, config.getSplitField());
            this.addJdbcSplit(jdbcTableHandle, splits, splitInfo, timeStamp, scanNodes, config);
            chunkOffset += chunkLength;
            autoIncrementOffset += chunkLength;
        }
        if (!config.isDataReadOnly()) {
            this.fillLastRecord(jdbcTableHandle, splits, scanNodes, timeStamp, fieldMinAndMaxValue[0], config);
            this.fillFirstRecord(jdbcTableHandle, splits, scanNodes, timeStamp, fieldMinAndMaxValue[1] - 1L, config);
        }
    }

    private void fillLastRecord(JdbcTableHandle jdbcTableHandle, List<JdbcSplit> splits, int scanNodes, long timeStamp, long endIndex, TableSplitConfig config) {
        String splitPart = config.getSplitField() + " > " + endIndex;
        this.addJdbcSplit(jdbcTableHandle, splits, new String[]{splitPart, String.valueOf(endIndex), String.valueOf(Long.MAX_VALUE)}, timeStamp, scanNodes, config);
    }

    private void fillFirstRecord(JdbcTableHandle jdbcTableHandle, List<JdbcSplit> splits, int scanNodes, long timeStamp, long startIndex, TableSplitConfig config) {
        String splitPart = config.getSplitField() + " <= " + startIndex;
        this.addJdbcSplit(jdbcTableHandle, splits, new String[]{splitPart, String.valueOf(Long.MIN_VALUE), String.valueOf(startIndex)}, timeStamp, scanNodes, config);
    }

    private String[] getSplitInfo(long chunkOffset, long autoIncrementOffset, Long[] splitFieldRangeValue, long chunkLength, long tableTotalRecords, String splitField) {
        String[] splitInfo = new String[3];
        splitInfo[1] = String.valueOf(autoIncrementOffset);
        String splitPart = splitField + " > " + autoIncrementOffset + " and " + splitField + " <= ";
        if (chunkOffset + chunkLength == tableTotalRecords) {
            splitPart = splitPart + splitFieldRangeValue[0];
            splitInfo[2] = String.valueOf(splitFieldRangeValue[0]);
        } else {
            splitPart = splitPart + (autoIncrementOffset + chunkLength);
            splitInfo[2] = String.valueOf(autoIncrementOffset + chunkLength);
        }
        splitInfo[0] = splitPart;
        return splitInfo;
    }
}

