/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcUpdatablePageSource;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcPageSourceProvider
implements ConnectorPageSourceProvider {
    private JdbcRecordSetProvider recordSetProvider;
    private final JdbcClient jdbcClient;
    private final BaseJdbcConfig config;

    @Inject
    public JdbcPageSourceProvider(@InternalBaseJdbc JdbcClient jdbcClient, BaseJdbcConfig config, JdbcRecordSetProvider recordSetProvider) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.config = Objects.requireNonNull(config, "config is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
        JdbcTableHandle jdbcTableHandle = (JdbcTableHandle)table;
        RecordSet recordSet = this.recordSetProvider.getRecordSet(transaction, session, split, table, columns);
        if (jdbcTableHandle.getDeleteOrUpdate().booleanValue()) {
            return new JdbcUpdatablePageSource(recordSet, session, table, this.jdbcClient, this.config, (JdbcSplit)split);
        }
        return new RecordPageSource(recordSet);
    }
}

