/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.prestosql.plugin.jdbc.InternalBaseJdbc;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcMetadataConfig;
import io.prestosql.plugin.jdbc.TransactionScopeCachingJdbcClient;
import io.prestosql.plugin.splitmanager.DataSourceTableSplitManager;
import io.prestosql.plugin.splitmanager.TableSplitFieldCheck;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;
    private final DataSourceTableSplitManager tableSplitManager;

    @Inject
    public JdbcMetadataFactory(@InternalBaseJdbc JdbcClient jdbcClient, JdbcMetadataConfig config, DataSourceTableSplitManager tableSplitManager) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.tableSplitManager = Objects.requireNonNull(tableSplitManager, "tableSplitManager is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public JdbcMetadata create() {
        return new JdbcMetadata(new TableSplitFieldCheck(new TransactionScopeCachingJdbcClient(this.jdbcClient), this.tableSplitManager), this.allowDropTable);
    }
}

