/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.prestosql.spi.function.Mandatory;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class JdbcMetadataConfig {
    private boolean allowDropTable;
    private Duration metadataCacheTtl = new Duration(1.0, TimeUnit.SECONDS);
    private long metadataCacheMaximumSize = 10000L;
    private boolean metadataCacheEnabled = true;

    public boolean isAllowDropTable() {
        return this.allowDropTable;
    }

    @Mandatory(name="allow-drop-table", description="Allow connector to drop tables", defaultValue="true")
    @Config(value="allow-drop-table")
    @ConfigDescription(value="Allow connector to drop tables")
    public JdbcMetadataConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    public boolean isMetadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    @Config(value="metadata-cache-enabled")
    @ConfigDescription(value="Enable metadata caching for Jdbc based connectors")
    public JdbcMetadataConfig setMetadataCacheEnabled(boolean metadataCacheEnabled) {
        this.metadataCacheEnabled = metadataCacheEnabled;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="metadata-cache-ttl")
    @ConfigDescription(value="Set the metadata cache eviction time for Jdbc based connectors")
    public JdbcMetadataConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getMetadataCacheMaximumSize() {
        return this.metadataCacheMaximumSize;
    }

    @Config(value="metadata-cache-maximum-size")
    @ConfigDescription(value="Set the metadata cache max size for Jdbc based connectors")
    public JdbcMetadataConfig setMetadataCacheMaximumSize(long metadataCacheMaximumSize) {
        this.metadataCacheMaximumSize = metadataCacheMaximumSize;
        return this;
    }
}

