/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Collections;
import java.util.Objects;

public final class JdbcColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final JdbcTypeHandle jdbcTypeHandle;
    private final Type columnType;
    private final boolean nullable;

    @JsonCreator
    public JdbcColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="jdbcTypeHandle") JdbcTypeHandle jdbcTypeHandle, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="nullable") boolean nullable) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jdbcTypeHandle = Objects.requireNonNull(jdbcTypeHandle, "jdbcTypeHandle is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.nullable = nullable;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public JdbcTypeHandle getJdbcTypeHandle() {
        return this.jdbcTypeHandle;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public boolean isNullable() {
        return this.nullable;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, this.nullable, null, null, false, Collections.emptyMap());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcColumnHandle o = (JdbcColumnHandle)obj;
        return Objects.equals(this.columnName, o.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return Joiner.on((String)":").join((Object)this.columnName, (Object)this.columnType.getDisplayName(), new Object[]{this.jdbcTypeHandle.getJdbcTypeName()});
    }
}

