/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.prestosql.plugin.basejdbc.ConnectionPoolFactory;
import io.prestosql.plugin.basejdbc.HetuConnectionObjectPool;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class DriverConnectionFactory
implements ConnectionFactory {
    private static final Logger LOG = Logger.get(DriverConnectionFactory.class);
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private final Optional<String> userCredentialName;
    private final Optional<String> passwordCredentialName;
    private final ConnectionPoolFactory connectionPoolFactory;
    private GenericObjectPoolConfig genericObjectPoolConfig;
    private AbandonedConfig abandonedConfig;
    private GenericObjectPool<Connection> genericObjectPool;
    private boolean isUseConnectionPool;

    public DriverConnectionFactory(Driver driver, BaseJdbcConfig config) {
        this(driver, config.getConnectionUrl(), Optional.ofNullable(config.getUserCredentialName()), Optional.ofNullable(config.getPasswordCredentialName()), DriverConnectionFactory.basicConnectionProperties(config));
    }

    public static Properties basicConnectionProperties(BaseJdbcConfig config) {
        Properties connectionProperties;
        block4: {
            connectionProperties = new Properties();
            if (config.getConnectionUser() != null) {
                connectionProperties.setProperty("user", config.getConnectionUser());
            }
            if (config.getConnectionPassword() != null) {
                connectionProperties.setProperty("password", config.getConnectionPassword());
            }
            try {
                connectionProperties.setProperty("useConnectionPool", "" + config.isUseConnectionPool());
                connectionProperties.setProperty("maxIdle", "" + config.getMaxIdle());
                connectionProperties.setProperty("minIdle", "" + config.getMinIdle());
                connectionProperties.setProperty("maxTotal", "" + config.getMaxTotal());
                connectionProperties.setProperty("lifo", "" + config.isLifo());
                connectionProperties.setProperty("fairness", "" + config.isFairness());
                connectionProperties.setProperty("maxWaitMillis", "" + config.getMaxWaitMillis());
                connectionProperties.setProperty("softMinEvictableIdleTimeMillis", "" + config.getSoftMinEvictableIdleTimeMillis());
                connectionProperties.setProperty("numTestsPerEvictionRun", "" + config.getNumTestsPerEvictionRun());
                connectionProperties.setProperty("testOnCreate", "" + config.isTestOnCreate());
                connectionProperties.setProperty("testOnBorrow", "" + config.isTestOnBorrow());
                connectionProperties.setProperty("testOnReturn", "" + config.isTestOnReturn());
                connectionProperties.setProperty("testWhileIdle", "" + config.isTestWhileIdle());
                connectionProperties.setProperty("timeBetweenEvictionRunsMillis", "" + config.getTimeBetweenEvictionRunsMillis());
                connectionProperties.setProperty("blockWhenExhausted", "" + config.isBlockWhenExhausted());
                connectionProperties.setProperty("jmxEnabled", "" + config.isJmxEnabled());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("basicConnectionProperties : set pool config failed... cause by", new Object[]{e});
            }
        }
        return connectionProperties;
    }

    public DriverConnectionFactory(Driver driver, String connectionUrl, Optional<String> userCredentialName, Optional<String> passwordCredentialName, Properties connectionProperties) {
        this.driver = Objects.requireNonNull(driver, "driver is null");
        this.connectionUrl = Objects.requireNonNull(connectionUrl, "connectionUrl is null");
        this.connectionProperties = new Properties();
        this.connectionProperties.putAll((Map<?, ?>)Objects.requireNonNull(connectionProperties, "basicConnectionProperties is null"));
        this.userCredentialName = Objects.requireNonNull(userCredentialName, "userCredentialName is null");
        this.passwordCredentialName = Objects.requireNonNull(passwordCredentialName, "passwordCredentialName is null");
        this.connectionPoolFactory = new ConnectionPoolFactory(driver, connectionUrl, connectionProperties);
        this.genericObjectPoolConfig = DriverConnectionFactory.createGenericObjectPoolConfig(connectionProperties);
        this.isUseConnectionPool = DriverConnectionFactory.isUseConnectionPool(connectionProperties);
        this.abandonedConfig = new AbandonedConfig();
        this.genericObjectPool = new HetuConnectionObjectPool(this.connectionPoolFactory, this.genericObjectPoolConfig, this.abandonedConfig);
    }

    public static boolean isUseConnectionPool(Properties connectionProperties) {
        return "true".equals(connectionProperties.get("useConnectionPool"));
    }

    public static GenericObjectPoolConfig createGenericObjectPoolConfig(Properties connectionProperties) {
        GenericObjectPoolConfig genericObjectPoolConfig;
        block3: {
            genericObjectPoolConfig = new GenericObjectPoolConfig();
            try {
                genericObjectPoolConfig.setMaxIdle(Integer.parseInt(connectionProperties.getProperty("maxIdle")));
                genericObjectPoolConfig.setMaxTotal(Integer.parseInt(connectionProperties.getProperty("maxTotal")));
                genericObjectPoolConfig.setMinIdle(Integer.parseInt(connectionProperties.getProperty("minIdle")));
                genericObjectPoolConfig.setLifo(Boolean.parseBoolean(connectionProperties.getProperty("lifo")));
                genericObjectPoolConfig.setFairness(Boolean.parseBoolean(connectionProperties.getProperty("fairness")));
                genericObjectPoolConfig.setMaxWaitMillis(Long.parseLong(connectionProperties.getProperty("maxWaitMillis")));
                genericObjectPoolConfig.setSoftMinEvictableIdleTimeMillis(Long.parseLong(connectionProperties.getProperty("softMinEvictableIdleTimeMillis")));
                genericObjectPoolConfig.setSoftMinEvictableIdleTimeMillis(Long.parseLong(connectionProperties.getProperty("softMinEvictableIdleTimeMillis")));
                genericObjectPoolConfig.setNumTestsPerEvictionRun(Integer.parseInt(connectionProperties.getProperty("numTestsPerEvictionRun")));
                genericObjectPoolConfig.setTestOnCreate(Boolean.parseBoolean(connectionProperties.getProperty("testOnCreate")));
                genericObjectPoolConfig.setTestOnBorrow(Boolean.parseBoolean(connectionProperties.getProperty("testOnBorrow")));
                genericObjectPoolConfig.setTestOnReturn(Boolean.parseBoolean(connectionProperties.getProperty("testOnReturn")));
                genericObjectPoolConfig.setTestWhileIdle(Boolean.parseBoolean(connectionProperties.getProperty("testWhileIdle")));
                genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(Long.parseLong(connectionProperties.getProperty("timeBetweenEvictionRunsMillis")));
                genericObjectPoolConfig.setBlockWhenExhausted(Boolean.parseBoolean(connectionProperties.getProperty("blockWhenExhausted")));
                genericObjectPoolConfig.setJmxEnabled(Boolean.parseBoolean(connectionProperties.getProperty("jmxEnabled")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("createGenericObjectPoolConfig: success... ");
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("createGenericObjectPoolConfig: failed... cause by ", new Object[]{e});
            }
        }
        return genericObjectPoolConfig;
    }

    @Override
    public Connection openConnection(JdbcIdentity identity) throws SQLException {
        Connection connection;
        block7: {
            connection = null;
            if (!this.isUseConnectionPool) {
                this.userCredentialName.ifPresent(credentialName -> DriverConnectionFactory.setConnectionProperty(this.connectionProperties, identity.getExtraCredentials(), credentialName, "user"));
                this.passwordCredentialName.ifPresent(credentialName -> DriverConnectionFactory.setConnectionProperty(this.connectionProperties, identity.getExtraCredentials(), credentialName, "password"));
                Properties connectionPropertiesClone = (Properties)this.connectionProperties.clone();
                DriverConnectionFactory.removeConnectionPool(connectionPropertiesClone);
                connection = this.driver.connect(this.connectionUrl, connectionPropertiesClone);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("openConnection: create Connection success...connection[%s]", new Object[]{connection.toString()});
                }
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("openConnection: getTestOnBorrow=%s, getTestOnCreate=%s", new Object[]{"" + this.genericObjectPool.getTestOnBorrow(), "" + this.genericObjectPool.getTestOnCreate()});
                    }
                    connection = (Connection)this.genericObjectPool.borrowObject();
                    connection.setReadOnly(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("openConnection: borrow Connection success...connection[%s]", new Object[]{connection.toString()});
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("openConnection: borrow Connection failed...cuase by %s", new Object[]{e.getMessage()});
                }
            }
        }
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection");
        return connection;
    }

    private static void setConnectionProperty(Properties connectionProperties, Map<String, String> extraCredentials, String credentialName, String propertyName) {
        String value = extraCredentials.get(credentialName);
        if (value != null) {
            connectionProperties.setProperty(propertyName, value);
        }
    }

    private static void removeConnectionPool(Properties connectionProperties) {
        connectionProperties.remove("useConnectionPool");
        connectionProperties.remove("maxIdle");
        connectionProperties.remove("minIdle");
        connectionProperties.remove("maxTotal");
        connectionProperties.remove("lifo");
        connectionProperties.remove("fairness");
        connectionProperties.remove("maxWaitMillis");
        connectionProperties.remove("softMinEvictableIdleTimeMillis");
        connectionProperties.remove("numTestsPerEvictionRun");
        connectionProperties.remove("testOnCreate");
        connectionProperties.remove("testOnBorrow");
        connectionProperties.remove("testOnReturn");
        connectionProperties.remove("testWhileIdle");
        connectionProperties.remove("timeBetweenEvictionRunsMillis");
        connectionProperties.remove("blockWhenExhausted");
        connectionProperties.remove("jmxEnabled");
    }
}

