/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.prestosql.plugin.jdbc.optimization.JdbcPushDownModule;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.function.Mandatory;
import io.prestosql.sql.builder.functioncall.BaseFunctionUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class BaseJdbcConfig {
    private String connectionUrl;
    private String connectionUser;
    private String connectionPassword;
    private String userCredentialName;
    private String passwordCredentialName;
    private boolean caseInsensitiveNameMatching;
    private boolean caseInsensitiveNameMatchingConfigured;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(1.0, TimeUnit.MINUTES);
    private boolean useConnectionPool;
    private int maxTotal = 50;
    private int maxIdle = 30;
    private int minIdle = 10;
    private boolean lifo = true;
    private boolean fairness;
    private long maxWaitMillis = -1L;
    private long softMinEvictableIdleTimeMillis = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean testOnCreate;
    private boolean testOnBorrow = true;
    private boolean testOnReturn;
    private boolean testWhileIdle = true;
    private long timeBetweenEvictionRunsMillis = -1L;
    private boolean blockWhenExhausted = true;
    private boolean jmxEnabled = true;
    private int fetchSize;
    private boolean dmlStatementsCommitInATransaction;
    private boolean pushDownEnable = true;
    private JdbcPushDownModule pushDownModule = JdbcPushDownModule.DEFAULT;
    private String pushDownExternalFunctionNamespaces;
    private String connectorRegistryFunctionNamespace;
    private boolean fieldSplitEnable;
    private String tableSplitFields;
    private Duration stepCalcRefreshInterval = new Duration(5.0, TimeUnit.MINUTES);
    private int stepCalcThreads = 4;

    public Optional<CatalogSchemaName> getConnectorRegistryFunctionNamespace() {
        return BaseFunctionUtil.parserExternalFunctionCatalogSchema(this.connectorRegistryFunctionNamespace);
    }

    @Config(value="connector.externalfunction.namespace")
    public BaseJdbcConfig setConnectorRegistryFunctionNamespace(String connectorRegistryFunctionNamespace) {
        this.connectorRegistryFunctionNamespace = connectorRegistryFunctionNamespace;
        return this;
    }

    @Nullable
    public List<CatalogSchemaName> getPushDownExternalFunctionNamespace() {
        return BaseFunctionUtil.parserPushDownSupportedRemoteCatalogSchema(this.pushDownExternalFunctionNamespaces);
    }

    @Config(value="jdbc.pushdown.remotenamespace")
    @ConfigDescription(value="The namespace in which remote function can push down, written in a specific catalog.schema, for example: mem.mysql, or in multiple specific catalog.schema, for example: mem.mysql|fs.mysql|metaCache.mysql")
    public BaseJdbcConfig setPushDownExternalFunctionNamespace(String pushDownExternalFunctionNamespaceStr) {
        this.pushDownExternalFunctionNamespaces = pushDownExternalFunctionNamespaceStr;
        return this;
    }

    public boolean isLifo() {
        return this.lifo;
    }

    @Config(value="jdbc.connection.pool.lifo")
    public BaseJdbcConfig setLifo(boolean lifo) {
        this.lifo = lifo;
        return this;
    }

    public boolean isFairness() {
        return this.fairness;
    }

    @Config(value="jdbc.connection.pool.fairness")
    public BaseJdbcConfig setFairness(boolean fairness) {
        this.fairness = fairness;
        return this;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    @Config(value="jdbc.connection.pool.maxWaitMillis")
    public BaseJdbcConfig setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
        return this;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    @Config(value="jdbc.connection.pool.softMinEvictableIdleTimeMillis")
    public BaseJdbcConfig setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        return this;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Config(value="jdbc.connection.pool.numTestsPerEvictionRun")
    public BaseJdbcConfig setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        return this;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    @Config(value="jdbc.connection.pool.testOnCreate")
    public BaseJdbcConfig setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        return this;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Config(value="jdbc.connection.pool.testOnBorrow")
    public BaseJdbcConfig setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        return this;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    @Config(value="jdbc.connection.pool.testOnReturn")
    public BaseJdbcConfig setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        return this;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Config(value="jdbc.connection.pool.testWhileIdle")
    public BaseJdbcConfig setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        return this;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    @Config(value="jdbc.connection.pool.timeBetweenEvictionRunsMillis")
    public BaseJdbcConfig setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        return this;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    @Config(value="jdbc.connection.pool.blockWhenExhausted")
    public BaseJdbcConfig setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
        return this;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    @Config(value="jdbc.connection.pool.jmxEnabled")
    public BaseJdbcConfig setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        return this;
    }

    @Nullable
    public int getMaxTotal() {
        return this.maxTotal;
    }

    @Config(value="jdbc.connection.pool.maxTotal")
    public BaseJdbcConfig setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    @Nullable
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Config(value="jdbc.connection.pool.maxIdle")
    public BaseJdbcConfig setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    @Nullable
    public int getMinIdle() {
        return this.minIdle;
    }

    @Config(value="jdbc.connection.pool.minIdle")
    public BaseJdbcConfig setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    @NotNull
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Mandatory(name="connection-url", description="the address of datasource", defaultValue="host1", required=true)
    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public boolean isUseConnectionPool() {
        return this.useConnectionPool;
    }

    @Config(value="use-connection-pool")
    public BaseJdbcConfig setUseConnectionPool(boolean useConnectionPool) {
        this.useConnectionPool = useConnectionPool;
        return this;
    }

    @Nullable
    public String getConnectionUser() {
        return this.connectionUser;
    }

    @Mandatory(name="connection-user", description="User to connect to remote database", defaultValue="root", required=true)
    @Config(value="connection-user")
    public BaseJdbcConfig setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
        return this;
    }

    @Nullable
    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    @Mandatory(name="connection-password", description="Password of user to connect to remote database", defaultValue="secret", required=true)
    @Config(value="connection-password")
    @ConfigSecuritySensitive
    public BaseJdbcConfig setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    @Nullable
    public String getUserCredentialName() {
        return this.userCredentialName;
    }

    @Config(value="user-credential-name")
    public BaseJdbcConfig setUserCredentialName(String userCredentialName) {
        this.userCredentialName = userCredentialName;
        return this;
    }

    @Nullable
    public String getPasswordCredentialName() {
        return this.passwordCredentialName;
    }

    @Config(value="password-credential-name")
    public BaseJdbcConfig setPasswordCredentialName(String passwordCredentialName) {
        this.passwordCredentialName = passwordCredentialName;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="case-insensitive-name-matching")
    public BaseJdbcConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        this.setCaseInsensitiveNameMatchingConfigured(true);
        return this;
    }

    public BaseJdbcConfig internalsetCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        if (!this.isCaseInsensitiveNameMatchingConfigured()) {
            this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        }
        return this;
    }

    public BaseJdbcConfig setCaseInsensitiveNameMatchingConfigured(boolean isConfigured) {
        this.caseInsensitiveNameMatchingConfigured = isConfigured;
        return this;
    }

    public boolean isCaseInsensitiveNameMatchingConfigured() {
        return this.caseInsensitiveNameMatchingConfigured;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="case-insensitive-name-matching.cache-ttl")
    public BaseJdbcConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getFetchSize() {
        return this.fetchSize;
    }

    @Config(value="fetch-size")
    @ConfigDescription(value="Customize JDBC fetch size. Assigning 0 will leave the default JDBC connection fetch size.")
    public BaseJdbcConfig setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Config(value="dml-statements-commit-in-a-transaction")
    @ConfigDescription(value="If a connection, all its DML statements, such as Insert, Update or Delete, will be executed and committed as a transaction. Default is false, every 1000 statements will be executed and committed as a transaction.")
    public BaseJdbcConfig setDmlStatementsCommitInATransaction(boolean dmlStatementsCommitInATransaction) {
        this.dmlStatementsCommitInATransaction = dmlStatementsCommitInATransaction;
        return this;
    }

    public boolean isDmlStatementsCommitInATransaction() {
        return this.dmlStatementsCommitInATransaction;
    }

    public boolean isPushDownEnable() {
        return this.pushDownEnable;
    }

    @Config(value="jdbc.pushdown-enabled")
    @ConfigDescription(value="Allow jdbc pushDown")
    public BaseJdbcConfig setPushDownEnable(boolean pushDownEnable) {
        this.pushDownEnable = pushDownEnable;
        return this;
    }

    public JdbcPushDownModule getPushDownModule() {
        return this.pushDownModule;
    }

    @Config(value="jdbc.pushdown-module")
    @ConfigDescription(value="jdbc query push down module in [FULL_PUSHDOWN, BASE_PUSHDOWN]")
    public BaseJdbcConfig setPushDownModule(JdbcPushDownModule pushDownModule) {
        this.pushDownModule = pushDownModule;
        return this;
    }

    @Config(value="jdbc.table-split-enabled")
    @ConfigDescription(value="table spilt function switch")
    public BaseJdbcConfig setTableSplitEnable(boolean fieldSplitEnable) {
        this.fieldSplitEnable = fieldSplitEnable;
        return this;
    }

    public boolean getTableSplitEnable() {
        return this.fieldSplitEnable;
    }

    @Config(value="jdbc.table-split-fields")
    @ConfigDescription(value="Allow multi split by one of table filed, this filed must be integer like value")
    public BaseJdbcConfig setTableSplitFields(String tableSplitFields) {
        this.tableSplitFields = tableSplitFields;
        return this;
    }

    public String getTableSplitFields() {
        return this.tableSplitFields;
    }

    @Config(value="jdbc.table-split-stepCalc-refresh-interval")
    public BaseJdbcConfig setTableSplitStepCalcRefreshInterval(Duration stepCalcRefreshInterval) {
        this.stepCalcRefreshInterval = stepCalcRefreshInterval;
        return this;
    }

    public Duration getTableSplitStepCalcRefreshInterval() {
        return this.stepCalcRefreshInterval;
    }

    @Config(value="jdbc.table-split-stepCalc-threads")
    public BaseJdbcConfig setTableSplitStepCalcCalcThreads(int stepCalcThreads) {
        this.stepCalcThreads = stepCalcThreads;
        return this;
    }

    public int getTableSplitStepCalcCalcThreads() {
        return this.stepCalcThreads;
    }
}

