/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.basejdbc;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.prestosql.plugin.basejdbc.HetuConnectionHandler;
import io.prestosql.plugin.basejdbc.HetuConnectionObjectPool;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ConnectionPoolFactory
implements PooledObjectFactory<Connection> {
    private static final Logger LOG = Logger.get(ConnectionPoolFactory.class);
    private final Driver driver;
    private final String connectionUrl;
    private final Properties connectionProperties;
    private HetuConnectionObjectPool forReturnConnection;
    private ConcurrentHashMap<Connection, HetuConnectionHandler> connectionHandlers = new ConcurrentHashMap();

    public ConnectionPoolFactory(Driver driver, String connectionUrl, Properties connectionProperties) {
        this.driver = driver;
        this.connectionUrl = connectionUrl;
        this.connectionProperties = connectionProperties;
    }

    public void setForReturnConnection(HetuConnectionObjectPool forReturnConnection) {
        this.forReturnConnection = forReturnConnection;
    }

    public PooledObject<Connection> makeObject() throws Exception {
        return this.wrap(this.create());
    }

    public void destroyObject(PooledObject<Connection> p) throws SQLException {
        Connection con = (Connection)p.getObject();
        if (con != null) {
            HetuConnectionHandler proxy = this.connectionHandlers.get(con);
            proxy.closeConnection();
            this.connectionHandlers.remove(con);
            if (LOG.isDebugEnabled()) {
                LOG.debug("destroyObject: connection close...connections[%s]", new Object[]{con.toString()});
            }
        }
    }

    public boolean validateObject(PooledObject<Connection> p) {
        block4: {
            Connection con = (Connection)p.getObject();
            if (con != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("validateObject: valid connecion[%s]' valid=%s", new Object[]{con.toString(), con.isValid(2)});
                    }
                    return con.isValid(1);
                }
                catch (SQLException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("validateObject: valid connection failed..cause by %s", new Object[]{e.getMessage()});
                }
            }
        }
        return false;
    }

    public void activateObject(PooledObject<Connection> p) throws SQLException {
    }

    public void passivateObject(PooledObject<Connection> p) throws SQLException {
    }

    public Connection create() throws SQLException {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.connectionUrl, this.connectionProperties);
            HetuConnectionHandler proxy = new HetuConnectionHandler();
            connection = proxy.bind(connection, this.forReturnConnection);
            this.connectionHandlers.put(connection, proxy);
        }
        catch (Exception e) {
            LOG.error("create: create Connection failed... cause by ", new Object[]{e});
        }
        Preconditions.checkState((connection != null ? 1 : 0) != 0, (Object)"Driver returned null connection");
        if (LOG.isDebugEnabled()) {
            LOG.debug("create(): create Connection success... connection[%s]", new Object[]{connection});
        }
        return connection;
    }

    public PooledObject<Connection> wrap(Connection connection) {
        return new DefaultPooledObject((Object)connection);
    }
}

