/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Ticker;
import io.airlift.stats.ExponentialDecay;
import io.airlift.stats.TDigest;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DecayTDigest {
    private static final long RESCALE_THRESHOLD_SECONDS = 50L;
    private static final double ZERO_WEIGHT_THRESHOLD = 1.0E-5;
    private final TDigest digest;
    private final Ticker ticker;
    private final double alpha;
    private long landmarkInSeconds;

    public DecayTDigest(double compression, double alpha) {
        this(new TDigest(compression), alpha, alpha == 0.0 ? DecayTDigest.noOpTicker() : Ticker.systemTicker());
    }

    private DecayTDigest(TDigest digest, double alpha, Ticker ticker) {
        this(digest, alpha, ticker, TimeUnit.NANOSECONDS.toSeconds(ticker.read()));
    }

    private DecayTDigest(TDigest digest, double alpha, Ticker ticker, long landmarkInSeconds) {
        this.digest = digest;
        this.alpha = alpha;
        this.ticker = ticker;
        this.landmarkInSeconds = landmarkInSeconds;
    }

    public double getMin() {
        if (this.getCount() < 1.0E-5) {
            return Double.NaN;
        }
        return this.digest.getMin();
    }

    public double getMax() {
        if (this.getCount() < 1.0E-5) {
            return Double.NaN;
        }
        return this.digest.getMax();
    }

    public double getCount() {
        double result = this.digest.getCount() / ExponentialDecay.weight(this.alpha, this.nowInSeconds(), this.landmarkInSeconds);
        if (result < 1.0E-5) {
            result = 0.0;
        }
        return result;
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        if (this.alpha > 0.0) {
            long nowInSeconds = this.nowInSeconds();
            if (nowInSeconds - this.landmarkInSeconds >= 50L) {
                this.rescale(nowInSeconds);
            }
            weight *= ExponentialDecay.weight(this.alpha, nowInSeconds, this.landmarkInSeconds);
        }
        this.digest.add(value, weight);
    }

    public double valueAt(double quantile) {
        return this.digest.valueAt(quantile);
    }

    public List<Double> valuesAt(List<Double> quantiles) {
        return this.digest.valuesAt(quantiles);
    }

    private void rescale(long newLandmarkInSeconds) {
        double factor = ExponentialDecay.weight(this.alpha, newLandmarkInSeconds, this.landmarkInSeconds);
        this.digest.totalWeight /= factor;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < this.digest.centroidCount; ++i) {
            double weight = this.digest.weights[i] / factor;
            if (weight < 1.0E-5) continue;
            this.digest.weights[index] = weight;
            this.digest.means[index] = this.digest.means[i];
            ++index;
            min = Math.min(min, this.digest.means[i]);
            max = Math.min(max, this.digest.means[i]);
        }
        this.digest.centroidCount = index;
        this.digest.min = min;
        this.digest.max = max;
        this.landmarkInSeconds = newLandmarkInSeconds;
    }

    private long nowInSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.ticker.read());
    }

    private static Ticker noOpTicker() {
        return new Ticker(){

            public long read() {
                return 0L;
            }
        };
    }

    public DecayTDigest duplicate() {
        return new DecayTDigest(TDigest.copyOf(this.digest), this.alpha, this.ticker, this.landmarkInSeconds);
    }
}

