/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Objects;

public final class DataCenterColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type columnType;
    private final int ordinalPosition;

    @JsonCreator
    public DataCenterColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="ordinalPosition") int ordinalPosition) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.ordinalPosition = ordinalPosition;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataCenterColumnHandle other = (DataCenterColumnHandle)obj;
        return this.columnName.equals(other.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("columnType", (Object)this.columnType).add("ordinalPosition", this.ordinalPosition).toString();
    }
}

