/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import io.hetu.core.plugin.datacenter.DataCenterQueryRunner;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestDCDynamicCatalogQueries {
    private final TestingPrestoServer hetuServer;
    private QueryRunner queryRunner;

    public TestDCDynamicCatalogQueries() throws Exception {
        this(new TestingPrestoServer((Map)ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"true").build()));
    }

    public TestDCDynamicCatalogQueries(TestingPrestoServer hetuServer) throws Exception {
        this.queryRunner = DataCenterQueryRunner.createDCQueryRunner(hetuServer, TpchTable.ORDERS);
        this.hetuServer = hetuServer;
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        this.hetuServer.close();
    }

    @Test
    public void testAddCatalogShow() {
        this.hetuServer.createCatalog("tpcm", "tpch");
        List rows = this.computeActual("show catalogs").getMaterializedRows();
        Assert.assertTrue((boolean)rows.stream().anyMatch(row -> row.getField(0).equals("dc.tpcm")));
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)this.computeActual("show schemas from dc.tpcm").getMaterializedRows(), (Collection)this.computeActual("show schemas from tpch").getMaterializedRows(), (String)"The show schemas query failed for the newly added catalog");
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)this.computeActual("show tables from dc.tpcm.tiny").getMaterializedRows(), (Collection)this.computeActual("show tables from tpch.tiny").getMaterializedRows(), (String)"The show tables query failed for the newly added catalog");
        this.hetuServer.deleteCatalog("tpcm");
        List rowsCatalogs = this.computeActual("show catalogs").getMaterializedRows();
        Assert.assertFalse((boolean)rowsCatalogs.stream().anyMatch(row -> row.getField(0).equals("dc.tpcm")));
        this.assertQueryFails("show schemas from dc.tpcm", "Catalog dc.tpcm does not exist");
    }

    @Test
    public void testAddCatalogUse() {
        this.hetuServer.createCatalog("tpcv", "tpch");
        this.assertQuerySucceeds("use dc.tpcv.tiny");
        this.hetuServer.deleteCatalog("tpcv");
        this.assertQueryFails("use dc.tpcv.tiny", "Catalog does not exist: dc.tpcv");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testAddCatalogSelect() {
        this.hetuServer.createCatalog("tpcn", "tpch");
        io.prestosql.testing.assertions.Assert.assertEquals((String)this.computeActual("select count(*) from dc.tpcn.tiny.orders").toString(), (String)this.computeActual("select count(*) from tpch.tiny.orders").toString(), (String)"The number of rows does not match");
        List actual = this.computeActual("select * from dc.tpcn.tiny.orders order by orderkey limit 10").getMaterializedRows();
        List expect = this.computeActual("select * from tpch.tiny.orders order by orderkey limit 10").getMaterializedRows();
        io.prestosql.testing.assertions.Assert.assertEquals((Collection)actual, (Collection)expect, (String)"The query results are not matching for both of the catalogs");
        this.hetuServer.deleteCatalog("tpcn");
        this.computeActual("select count(*) from dc.tpcn.tiny.orders");
        Assert.fail((String)"Able to query from deleted catalog");
    }

    protected MaterializedResult computeActual(String sql) {
        return this.queryRunner.execute(this.queryRunner.getDefaultSession(), sql).toTestTypes();
    }

    protected void assertQuerySucceeds(String sql) {
        try {
            this.queryRunner.execute(this.queryRunner.getDefaultSession(), sql);
        }
        catch (RuntimeException e) {
            Assert.fail((String)String.format("Expected query to succeed: %s", sql), (Throwable)e);
        }
    }

    protected void assertQueryFails(String sql, String expectedMessageRegExp) {
        block2: {
            try {
                this.queryRunner.execute(this.queryRunner.getDefaultSession(), sql);
                Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
            catch (RuntimeException ex) {
                if (Strings.nullToEmpty((String)ex.getMessage()).matches(expectedMessageRegExp)) break block2;
                Assert.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", ex.getMessage(), expectedMessageRegExp, sql), (Throwable)ex);
            }
        }
    }
}

