/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import io.hetu.core.plugin.datacenter.DataCenterQueryRunner;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.tests.AbstractTestDistributedQueries;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestDCDistributedQueries
extends AbstractTestDistributedQueries {
    private final TestingPrestoServer hetuServer;

    public TestDCDistributedQueries() throws Exception {
        this(new TestingPrestoServer((Map)ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"true").put((Object)"hetu.data.center.split.count", (Object)"2").build()));
    }

    private TestDCDistributedQueries(TestingPrestoServer hetuServer) {
        super(() -> DataCenterQueryRunner.createDCQueryRunner(hetuServer, (Map<String, String>)ImmutableMap.of(), TpchTable.getTables()));
        this.hetuServer = hetuServer;
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        this.hetuServer.close();
    }

    protected boolean supportsViews() {
        return false;
    }

    protected boolean supportsArrays() {
        return false;
    }

    private boolean supportsBatchInsert() {
        return false;
    }

    public void testAddColumn() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testAddColumn();
    }

    public void testCreateTable() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testCreateTable();
    }

    public void testCreateTableAsSelect() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testCreateTableAsSelect();
    }

    public void testDropColumn() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testCreateTableAsSelect();
    }

    public void testCommentTable() {
        this.assertQueryFails("COMMENT ON TABLE orders IS 'hello'", "This connector does not support setting table comments");
    }

    public void testDelete() {
    }

    public void testLargeQuerySuccess() {
    }

    public void testInsert() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testInsert();
    }

    public void testQueryLoggingCount() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testQueryLoggingCount();
    }

    public void testRenameColumn() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testRenameColumn();
    }

    public void testRenameTable() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testRenameTable();
    }

    public void testSymbolAliasing() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testSymbolAliasing();
    }

    public void testWrittenStats() {
        TestDCDistributedQueries.skipTestUnless((boolean)this.supportsBatchInsert());
        super.testWrittenStats();
    }

    @Test
    public void testLargeIn() {
        String longValues = IntStream.range(0, 100).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (" + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey IN (mod(1000, orderkey), " + longValues + ")");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderkey NOT IN (mod(1000, orderkey), " + longValues + ")");
        String arrayValues = IntStream.range(0, 100).mapToObj(i -> String.format("ARRAY[%s, %s, %s]", i, i + 1, i + 2)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (ARRAY[0, 0, 0], " + arrayValues + ")", "values true");
        this.assertQuery("SELECT ARRAY[0, 0, 0] in (" + arrayValues + ")", "values false");
    }

    @Test
    public void testDeadLock() throws InterruptedException, ExecutionException, TimeoutException {
        final class ThreadPerTaskExecutor
        implements Executor {
            ThreadPerTaskExecutor() {
            }

            @Override
            public void execute(Runnable runnable) {
                new Thread(runnable).start();
            }
        }
        ThreadPerTaskExecutor threadPerTaskExec = new ThreadPerTaskExecutor();
        CompletableFuture<Void> testMergeHLLCallableFuture = CompletableFuture.supplyAsync(() -> {
            this.testMergeHyperLogLog();
            return null;
        }, threadPerTaskExec);
        CompletableFuture<Void> testShowCatalogsCallableFuture = CompletableFuture.supplyAsync(() -> {
            this.testShowCatalogs();
            return null;
        }, threadPerTaskExec);
        CompletableFuture<Void> combined = CompletableFuture.allOf(testShowCatalogsCallableFuture, testMergeHLLCallableFuture);
        combined.get(6000L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)testShowCatalogsCallableFuture.isDone());
        Assert.assertTrue((boolean)testMergeHLLCallableFuture.isDone());
    }
}

