/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.hetu.core.transport.execution.buffer.PageCodecMarker;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.snapshot.MarkerPage;
import io.prestosql.spi.snapshot.Restorable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.openjdk.jol.info.ClassLayout;

public class SerializedPage
implements Restorable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPage.class).instanceSize();
    private final Slice slice;
    private final int positionCount;
    private final int uncompressedSizeInBytes;
    private final byte pageCodecMarkers;
    private Properties pageMetadata = new Properties();
    private String origin;

    public static SerializedPage forMarker(MarkerPage marker) {
        byte[] bytes = marker.serialize();
        return new SerializedPage(bytes, PageCodecMarker.MARKER_PAGE.set(PageCodecMarker.none()), 1, bytes.length);
    }

    @JsonCreator
    public SerializedPage(@JsonProperty(value="sliceArray") byte[] sliceArray, @JsonProperty(value="pageCodecMarkers") byte pageCodecMarkers, @JsonProperty(value="positionCount") int positionCount, @JsonProperty(value="uncompressedSizeInBytes") int uncompressedSizeInBytes, @JsonProperty(value="pageMetadata") Properties pageMetadata) {
        this(Slices.wrappedBuffer((byte[])sliceArray), PageCodecMarker.MarkerSet.fromByteValue(pageCodecMarkers), positionCount, uncompressedSizeInBytes, pageMetadata);
    }

    public SerializedPage(byte[] sliceArray, byte pageCodecMarkers, int positionCount, int uncompressedSizeInBytes) {
        this(Slices.wrappedBuffer((byte[])sliceArray), PageCodecMarker.MarkerSet.fromByteValue(pageCodecMarkers), positionCount, uncompressedSizeInBytes);
    }

    public SerializedPage(Slice slice, PageCodecMarker.MarkerSet markers, int positionCount, int uncompressedSizeInBytes, Properties pageMetadata) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.positionCount = positionCount;
        Preconditions.checkArgument((uncompressedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"uncompressedSizeInBytes is negative");
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        this.pageCodecMarkers = Objects.requireNonNull(markers, "markers is null").byteValue();
        Properties properties = this.pageMetadata = pageMetadata == null ? new Properties() : pageMetadata;
        if (!markers.contains(PageCodecMarker.ENCRYPTED)) {
            if (markers.contains(PageCodecMarker.COMPRESSED)) {
                Preconditions.checkArgument((uncompressedSizeInBytes > slice.length() ? 1 : 0) != 0, (Object)"compressed size must be smaller than uncompressed size when compressed");
            } else {
                Preconditions.checkArgument((uncompressedSizeInBytes == slice.length() ? 1 : 0) != 0, (Object)"uncompressed size must be equal to slice length when uncompressed");
            }
        }
    }

    public SerializedPage(Slice slice, PageCodecMarker.MarkerSet markers, int positionCount, int uncompressedSizeInBytes) {
        this(slice, markers, positionCount, uncompressedSizeInBytes, null);
    }

    public int getSizeInBytes() {
        return this.slice.length();
    }

    @JsonProperty
    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    @JsonProperty
    public int getPositionCount() {
        return this.positionCount;
    }

    @JsonProperty
    public byte[] getSliceArray() {
        return this.slice.getBytes();
    }

    public Slice getSlice() {
        return this.slice;
    }

    @JsonProperty
    public byte getPageCodecMarkers() {
        return this.pageCodecMarkers;
    }

    public boolean isCompressed() {
        return PageCodecMarker.COMPRESSED.isSet(this.pageCodecMarkers);
    }

    public boolean isEncrypted() {
        return PageCodecMarker.ENCRYPTED.isSet(this.pageCodecMarkers);
    }

    public boolean isMarkerPage() {
        return PageCodecMarker.MARKER_PAGE.isSet(this.pageCodecMarkers);
    }

    public MarkerPage toMarker() {
        Preconditions.checkState((boolean)this.isMarkerPage());
        return MarkerPage.deserialize((byte[])this.getSliceArray());
    }

    @JsonProperty
    public Properties getPageMetadata() {
        return this.pageMetadata;
    }

    public Optional<String> getOrigin() {
        return Optional.ofNullable(this.origin);
    }

    public SerializedPage setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("pageCodecMarkers", (Object)PageCodecMarker.toSummaryString(this.pageCodecMarkers)).add("sizeInBytes", this.slice.length()).add("uncompressedSizeInBytes", this.uncompressedSizeInBytes).add("pageMetadata", (Object)this.pageMetadata).toString();
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        SerializedPageState state = new SerializedPageState();
        SerializedPageState.access$102(state, this.getSliceArray());
        state.positionCount = this.getPositionCount();
        state.uncompressedSizeInBytes = this.getUncompressedSizeInBytes();
        state.pageCodecMarkers = this.getPageCodecMarkers();
        state.origin = this.origin;
        return state;
    }

    public static SerializedPage restoreSerializedPage(Object state) {
        SerializedPageState serializedPageState = (SerializedPageState)state;
        return new SerializedPage(serializedPageState.slice, serializedPageState.pageCodecMarkers, serializedPageState.positionCount, serializedPageState.uncompressedSizeInBytes).setOrigin(serializedPageState.origin);
    }

    private static class SerializedPageState
    implements Serializable {
        private byte[] slice;
        private int positionCount;
        private int uncompressedSizeInBytes;
        private byte pageCodecMarkers;
        private String origin;

        private SerializedPageState() {
        }

        static /* synthetic */ byte[] access$102(SerializedPageState x0, byte[] x1) {
            x0.slice = x1;
            return x1;
        }
    }
}

