/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.jdbc;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcOutputTableHandle;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.QueryBuilder;
import io.prestosql.plugin.jdbc.RemoteTableNameCacheKey;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.function.ExternalFunctionHub;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import io.prestosql.sql.builder.functioncall.JdbcExternalFunctionHub;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.PreDestroy;

public class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    private static final Map<Type, WriteMapping> WRITE_MAPPINGS = ImmutableMap.builder().put((Object)BooleanType.BOOLEAN, (Object)WriteMapping.booleanMapping("boolean", StandardColumnMappings.booleanWriteFunction())).put((Object)BigintType.BIGINT, (Object)WriteMapping.longMapping("bigint", StandardColumnMappings.bigintWriteFunction())).put((Object)IntegerType.INTEGER, (Object)WriteMapping.longMapping("integer", StandardColumnMappings.integerWriteFunction())).put((Object)SmallintType.SMALLINT, (Object)WriteMapping.longMapping("smallint", StandardColumnMappings.smallintWriteFunction())).put((Object)TinyintType.TINYINT, (Object)WriteMapping.longMapping("tinyint", StandardColumnMappings.tinyintWriteFunction())).put((Object)DoubleType.DOUBLE, (Object)WriteMapping.doubleMapping("double precision", StandardColumnMappings.doubleWriteFunction())).put((Object)RealType.REAL, (Object)WriteMapping.longMapping("real", StandardColumnMappings.realWriteFunction())).put((Object)VarbinaryType.VARBINARY, (Object)WriteMapping.sliceMapping("varbinary", StandardColumnMappings.varbinaryWriteFunction())).put((Object)DateType.DATE, (Object)WriteMapping.longMapping("date", StandardColumnMappings.dateWriteFunction())).build();
    protected final ConnectionFactory connectionFactory;
    protected final String identifierQuote;
    protected final boolean caseInsensitiveNameMatching;
    protected final Cache<JdbcIdentity, Map<String, String>> remoteSchemaNames;
    protected final Cache<RemoteTableNameCacheKey, Map<String, String>> remoteTableNames;
    protected final int fetchSize;
    private final ExternalFunctionHub externalFunctionHub;

    public BaseJdbcClient(BaseJdbcConfig config, String identifierQuote, ConnectionFactory connectionFactory) {
        this(identifierQuote, connectionFactory, Objects.requireNonNull(config, "config is null").isCaseInsensitiveNameMatching(), config.getCaseInsensitiveNameMatchingCacheTtl(), config.getFetchSize(), new JdbcExternalFunctionHub());
    }

    public BaseJdbcClient(BaseJdbcConfig config, String identifierQuote, ConnectionFactory connectionFactory, ExternalFunctionHub externalFunctionHub) {
        this(identifierQuote, connectionFactory, Objects.requireNonNull(config, "config is null").isCaseInsensitiveNameMatching(), config.getCaseInsensitiveNameMatchingCacheTtl(), config.getFetchSize(), externalFunctionHub);
    }

    public BaseJdbcClient(String identifierQuote, ConnectionFactory connectionFactory, boolean caseInsensitiveNameMatching, Duration caseInsensitiveNameMatchingCacheTtl) {
        this(identifierQuote, connectionFactory, caseInsensitiveNameMatching, caseInsensitiveNameMatchingCacheTtl, -1, new JdbcExternalFunctionHub());
    }

    public BaseJdbcClient(String identifierQuote, ConnectionFactory connectionFactory, boolean caseInsensitiveNameMatching, Duration caseInsensitiveNameMatchingCacheTtl, int fetchSize, ExternalFunctionHub externalFunctionHub) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        Objects.requireNonNull(caseInsensitiveNameMatchingCacheTtl, "caseInsensitiveNameMatchingCacheTtl is null");
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        CacheBuilder remoteNamesCacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(caseInsensitiveNameMatchingCacheTtl.toMillis(), TimeUnit.MILLISECONDS);
        this.remoteSchemaNames = remoteNamesCacheBuilder.build();
        this.remoteTableNames = remoteNamesCacheBuilder.build();
        this.fetchSize = fetchSize;
        this.externalFunctionHub = Objects.requireNonNull(externalFunctionHub, "externalFunctionHub is null");
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.connectionFactory.close();
    }

    @Override
    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Set<String> getSchemaNames(JdbcIdentity identity) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            Set set = (Set)this.listSchemas(connection).stream().map(schemaName -> schemaName.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
            return set;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> listSchemas(Connection connection) {
        try (ResultSet resultSet = connection.getMetaData().getSchemas();){
            ImmutableSet.Builder schemaNames = ImmutableSet.builder();
            while (resultSet.next()) {
                String schemaName = resultSet.getString("TABLE_SCHEM");
                if (schemaName.equalsIgnoreCase("information_schema")) continue;
                schemaNames.add((Object)schemaName);
            }
            ImmutableSet immutableSet = schemaNames.build();
            return immutableSet;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<SchemaTableName> getTableNames(JdbcIdentity identity, Optional<String> schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<JdbcTableHandle> getTableHandle(JdbcIdentity identity, SchemaTableName schemaTableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return StandardColumnMappings.jdbcTypeToPrestoType(session, typeHandle);
    }

    @Override
    public ConnectorSplitSource getSplits(JdbcIdentity identity, JdbcTableHandle tableHandle) {
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)new JdbcSplit(Optional.empty())));
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcSplit split) throws SQLException {
        Connection connection = this.connectionFactory.openConnection(identity);
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        if (table.getGeneratedSql().isPresent()) {
            return new QueryBuilder(this.identifierQuote, true).buildSql(this, session, connection, null, null, table.getGeneratedSql().get().getSql(), columns, table.getConstraint(), split.getAdditionalPredicate(), this.tryApplyLimit(table.getLimit()));
        }
        return new QueryBuilder(this.identifierQuote).buildSql(this, session, connection, table.getCatalogName(), table.getSchemaName(), table.getTableName(), columns, table.getConstraint(), split.getAdditionalPredicate(), this.tryApplyLimit(table.getLimit()));
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.beginWriteTable(session, tableMetadata);
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.beginWriteTable(session, tableMetadata);
    }

    private JdbcOutputTableHandle beginWriteTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            return this.createTable(session, tableMetadata, this.generateTemporaryTableName());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, String tableName) throws SQLException {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        JdbcIdentity identity = JdbcIdentity.from(session);
        if (!this.getSchemaNames(identity).contains(schemaTableName.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema not found: " + schemaTableName.getSchemaName());
        }
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            boolean uppercase = connection.getMetaData().storesUpperCaseIdentifiers();
            String remoteSchema = this.toRemoteSchemaName(identity, connection, schemaTableName.getSchemaName());
            String remoteTable = this.toRemoteTableName(identity, connection, remoteSchema, schemaTableName.getTableName());
            if (uppercase) {
                tableName = tableName.toUpperCase(Locale.ENGLISH);
            }
            String catalog = connection.getCatalog();
            ImmutableList.Builder columnNames = ImmutableList.builder();
            ImmutableList.Builder columnTypes = ImmutableList.builder();
            ImmutableList.Builder columnList = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                String columnName = column.getName();
                if (uppercase) {
                    columnName = columnName.toUpperCase(Locale.ENGLISH);
                }
                columnNames.add((Object)columnName);
                columnTypes.add((Object)column.getType());
                columnList.add((Object)this.getColumnSql(session, column, columnName));
            }
            String sql = String.format("CREATE TABLE %s (%s)", this.quoted(catalog, remoteSchema, tableName), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)columnList.build()));
            this.execute(connection, sql);
            JdbcOutputTableHandle jdbcOutputTableHandle = new JdbcOutputTableHandle(catalog, remoteSchema, remoteTable, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), tableName);
            return jdbcOutputTableHandle;
        }
    }

    private String getColumnSql(ConnectorSession session, ColumnMetadata column, String columnName) {
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ").append(this.toWriteMapping(session, column.getType()).getDataType());
        if (!column.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    protected String generateTemporaryTableName() {
        return "tmp_presto_" + UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public void commitCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.renameTable(identity, handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName(), new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void renameTable(JdbcIdentity identity, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.renameTable(identity, handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), newTableName);
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            String newSchemaName = newTable.getSchemaName();
            String newTableName = newTable.getTableName();
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                newSchemaName = newSchemaName.toUpperCase(Locale.ENGLISH);
                newTableName = newTableName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(catalogName, newSchemaName, newTableName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void finishInsertTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        Throwable throwable;
        Connection connection;
        String temporaryTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName());
        String targetTable = this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName());
        String insertSql = String.format("INSERT INTO %s SELECT * FROM %s", targetTable, temporaryTable);
        String cleanupSql = "DROP TABLE " + temporaryTable;
        try {
            connection = this.getConnection(identity, handle);
            throwable = null;
            try {
                this.execute(connection, insertSql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            connection = this.getConnection(identity, handle);
            throwable = null;
            try {
                this.execute(connection, cleanupSql);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.warn((Throwable)e, "Failed to cleanup temporary table: %s", new Object[]{temporaryTable});
        }
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        try (Connection connection = this.connectionFactory.openConnection(JdbcIdentity.from(session));){
            String columnName = column.getName();
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                columnName = columnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s ADD %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), this.getColumnSql(session, column, columnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            if (connection.getMetaData().storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), jdbcColumn.getColumnName(), newColumnName);
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle column) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), column.getColumnName());
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(JdbcIdentity identity, JdbcTableHandle handle) {
        String sql = "DROP TABLE " + this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName());
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void rollbackCreateTable(JdbcIdentity identity, JdbcOutputTableHandle handle) {
        this.dropTable(identity, new JdbcTableHandle(new SchemaTableName(handle.getSchemaName(), handle.getTemporaryTableName()), handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()));
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle) {
        return String.format("INSERT INTO %s VALUES (%s)", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName()), String.join((CharSequence)",", Collections.nCopies(handle.getColumnNames().size(), "?")));
    }

    @Override
    public Connection getConnection(JdbcIdentity identity, JdbcOutputTableHandle handle) throws SQLException {
        return this.connectionFactory.openConnection(identity);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (this.fetchSize > 0) {
            preparedStatement.setFetchSize(this.fetchSize);
        }
        return preparedStatement;
    }

    @Override
    public Optional<ExternalFunctionHub> getExternalFunctionHub() {
        return Optional.of(this.externalFunctionHub);
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getTables(connection.getCatalog(), BaseJdbcClient.escapeNamePattern(schemaName, escape).orElse(null), BaseJdbcClient.escapeNamePattern(tableName, escape).orElse(null), new String[]{"TABLE", "VIEW"});
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_SCHEM");
    }

    protected String toRemoteSchemaName(JdbcIdentity identity, Connection connection, String schemaName) {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)schemaName), (String)"Expected schema name from internal metadata to be lowercase: %s", (Object)schemaName);
        if (this.caseInsensitiveNameMatching) {
            try {
                String remoteSchema;
                Map<String, String> mapping = (Map<String, String>)this.remoteSchemaNames.getIfPresent((Object)identity);
                if (mapping != null && !mapping.containsKey(schemaName)) {
                    mapping = null;
                }
                if (mapping == null) {
                    mapping = this.listSchemasByLowerCase(connection);
                    this.remoteSchemaNames.put((Object)identity, mapping);
                }
                if ((remoteSchema = (String)mapping.get(schemaName)) != null) {
                    return remoteSchema;
                }
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote schema name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
            }
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                return schemaName.toUpperCase(Locale.ENGLISH);
            }
            return schemaName;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected Map<String, String> listSchemasByLowerCase(Connection connection) {
        return (Map)this.listSchemas(connection).stream().collect(ImmutableMap.toImmutableMap(schemaName -> schemaName.toLowerCase(Locale.ENGLISH), schemaName -> schemaName));
    }

    protected String toRemoteTableName(JdbcIdentity identity, Connection connection, String remoteSchema, String tableName) {
        Objects.requireNonNull(remoteSchema, "remoteSchema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Verify.verify((boolean)CharMatcher.forPredicate(Character::isUpperCase).matchesNoneOf((CharSequence)tableName), (String)"Expected table name from internal metadata to be lowercase: %s", (Object)tableName);
        if (this.caseInsensitiveNameMatching) {
            try {
                String remoteTable;
                RemoteTableNameCacheKey cacheKey = new RemoteTableNameCacheKey(identity, remoteSchema);
                Map<String, String> mapping = (Map<String, String>)this.remoteTableNames.getIfPresent((Object)cacheKey);
                if (mapping != null && !mapping.containsKey(tableName)) {
                    mapping = null;
                }
                if (mapping == null) {
                    mapping = this.listTablesByLowerCase(connection, remoteSchema);
                    this.remoteTableNames.put((Object)cacheKey, mapping);
                }
                if ((remoteTable = (String)mapping.get(tableName)) != null) {
                    return remoteTable;
                }
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to find remote table name: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
            }
        }
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                return tableName.toUpperCase(Locale.ENGLISH);
            }
            return tableName;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, String> listTablesByLowerCase(Connection connection, String remoteSchema) {
        try (ResultSet resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.empty());){
            ImmutableMap.Builder map = ImmutableMap.builder();
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                map.put((Object)tableName.toLowerCase(Locale.ENGLISH), (Object)tableName);
            }
            ImmutableMap immutableMap = map.build();
            return immutableMap;
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        return TableStatistics.empty();
    }

    protected void execute(Connection connection, String query) throws SQLException {
        try (Statement statement = connection.createStatement();){
            log.debug("Execute: %s", new Object[]{query});
            statement.execute(query);
        }
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            String dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping(dataType, StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping("char(" + ((CharType)type).getLength() + ")", StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping(dataType, StandardColumnMappings.shortDecimalWriteFunction(decimalType));
            }
            return WriteMapping.sliceMapping(dataType, StandardColumnMappings.longDecimalWriteFunction(decimalType));
        }
        WriteMapping writeMapping = WRITE_MAPPINGS.get(type);
        if (writeMapping != null) {
            return writeMapping;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected Function<String, String> tryApplyLimit(OptionalLong limit) {
        if (!limit.isPresent()) {
            return Function.identity();
        }
        return this.limitFunction().map(limitFunction -> sql -> (String)limitFunction.apply(sql, limit.getAsLong())).orElseGet(Function::identity);
    }

    @Override
    public boolean supportsLimit() {
        return this.limitFunction().isPresent();
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.empty();
    }

    @Override
    public boolean isLimitGuaranteed() {
        throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "limitFunction() is implemented without isLimitGuaranteed()");
    }

    protected String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    protected String quoted(String catalog, String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected static Optional<String> escapeNamePattern(Optional<String> name, Optional<String> escape) {
        if (!name.isPresent() || !escape.isPresent()) {
            return name;
        }
        return Optional.of(BaseJdbcClient.escapeNamePattern(name.get(), escape.get()));
    }

    private static String escapeNamePattern(String name, String escape) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(escape, "escape is null");
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    protected static ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getColumns(tableHandle.getCatalogName(), BaseJdbcClient.escapeNamePattern(Optional.ofNullable(tableHandle.getSchemaName()), escape).orElse(null), BaseJdbcClient.escapeNamePattern(Optional.ofNullable(tableHandle.getTableName()), escape).orElse(null), null);
    }

    private /* synthetic */ String lambda$getTableNames$1(JdbcIdentity identity, Connection connection, String schemaName) {
        return this.toRemoteSchemaName(identity, connection, schemaName);
    }
}

