/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Delete
extends Statement {
    private final Table table;
    private final Optional<Expression> where;

    public Delete(Table table, Optional<Expression> where) {
        this(Optional.empty(), table, where);
    }

    public Delete(NodeLocation location, Table table, Optional<Expression> where) {
        this(Optional.of(location), table, where);
    }

    private Delete(Optional<NodeLocation> location, Table table, Optional<Expression> where) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.table);
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Delete o = (Delete)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table.getName()).add("where", this.where).toString();
    }
}

