/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils.rx;

import io.hengam.lib.utils.rx.Relay;
import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishRelay<T>
extends Relay<T> {
    static final PublishDisposable[] EMPTY = new PublishDisposable[0];
    final AtomicReference<PublishDisposable<T>[]> subscribers = new AtomicReference<PublishDisposable[]>(EMPTY);

    @CheckReturnValue
    @NonNull
    public static <T> PublishRelay<T> create() {
        return new PublishRelay<T>();
    }

    PublishRelay() {
    }

    protected void subscribeActual(Observer<? super T> t) {
        PublishDisposable<T> ps = new PublishDisposable<T>(t, this);
        t.onSubscribe(ps);
        this.add(ps);
        if (ps.isDisposed()) {
            this.remove(ps);
        }
    }

    void add(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            a = this.subscribers.get();
            int n = a.length;
            b = new PublishDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!this.subscribers.compareAndSet(a, b));
    }

    void remove(PublishDisposable<T> ps) {
        PublishDisposable[] b;
        PublishDisposable<T>[] a;
        do {
            if ((a = this.subscribers.get()) == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new PublishDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    @Override
    public void accept(T value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        for (PublishDisposable<T> s : this.subscribers.get()) {
            s.onNext(value);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.subscribers.get().length != 0;
    }

    static final class PublishDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 3562861878281475070L;
        final Observer<? super T> downstream;
        final PublishRelay<T> parent;

        PublishDisposable(Observer<? super T> actual, PublishRelay<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        public void onNext(T t) {
            if (!this.get()) {
                this.downstream.onNext(t);
            }
        }

        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get();
        }
    }
}

