/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils.rx;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.hengam.lib.utils.rx.HandlerScheduler;
import io.hengam.lib.utils.rx.RxAndroidPlugins;
import io.reactivex.Scheduler;
import java.util.concurrent.Callable;

public final class RxAndroid {
    private static final Scheduler MAIN_THREAD = RxAndroidPlugins.initMainThreadScheduler(new Callable<Scheduler>(){

        @Override
        public Scheduler call() throws Exception {
            return MainHolder.DEFAULT;
        }
    });

    public static Scheduler mainThread() {
        return RxAndroidPlugins.onMainThreadScheduler(MAIN_THREAD);
    }

    public static Scheduler from(Looper looper) {
        return RxAndroid.from(looper, false);
    }

    @SuppressLint(value={"NewApi"})
    public static Scheduler from(Looper looper, boolean async) {
        if (looper == null) {
            throw new NullPointerException("looper == null");
        }
        if (Build.VERSION.SDK_INT < 16) {
            async = false;
        } else if (async && Build.VERSION.SDK_INT < 22) {
            Message message = Message.obtain();
            try {
                message.setAsynchronous(true);
            }
            catch (NoSuchMethodError e) {
                async = false;
            }
            message.recycle();
        }
        return new HandlerScheduler(new Handler(looper), async);
    }

    private RxAndroid() {
        throw new AssertionError((Object)"No instances.");
    }

    private static final class MainHolder {
        static final Scheduler DEFAULT = new HandlerScheduler(new Handler(Looper.getMainLooper()), false);

        private MainHolder() {
        }
    }
}

