/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils.rx;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import java.util.concurrent.Callable;

public final class SafeSingleFromCallable<T>
extends Single<T> {
    final Callable<? extends T> callable;

    public SafeSingleFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    protected void subscribeActual(SingleObserver<? super T> observer) {
        T value;
        Disposable d = Disposables.empty();
        observer.onSubscribe(d);
        if (d.isDisposed()) {
            return;
        }
        try {
            value = this.callable.call();
            if (value == null) {
                throw new NullPointerException("The callable returned a null value");
            }
        }
        catch (Throwable ex) {
            if (!d.isDisposed()) {
                observer.onError(ex);
            }
            return;
        }
        if (!d.isDisposed()) {
            observer.onSuccess(value);
        }
    }
}

