/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import android.content.Context;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J'\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006 "}, d2={"Lio/hengam/lib/utils/PermissionChecker;", "", "()V", "ACCESS_COARSE_LOCATION", "", "getACCESS_COARSE_LOCATION", "()Ljava/lang/String;", "ACCESS_FINE_LOCATION", "getACCESS_FINE_LOCATION", "ACCESS_NETWORK_STATE", "getACCESS_NETWORK_STATE", "ACCESS_WIFI_STATE", "getACCESS_WIFI_STATE", "ACTIVITY_RECOGNITION", "getACTIVITY_RECOGNITION", "GET_ACCOUNTS", "getGET_ACCOUNTS", "READ_PHONE_STATE", "getREAD_PHONE_STATE", "hasPermission", "", "context", "Landroid/content/Context;", "permission", "hasPermissions", "permissions", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "ifHasPermission", "", "toDo", "Lkotlin/Function0;", "utils_release"})
public final class PermissionChecker {
    @NotNull
    private static final String ACCESS_NETWORK_STATE = "android.permission.ACCESS_NETWORK_STATE";
    @NotNull
    private static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    @NotNull
    private static final String ACCESS_COARSE_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    @NotNull
    private static final String ACCESS_FINE_LOCATION = "android.permission.ACCESS_FINE_LOCATION";
    @NotNull
    private static final String ACCESS_WIFI_STATE = "android.permission.ACCESS_WIFI_STATE";
    @NotNull
    private static final String GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    @NotNull
    private static final String ACTIVITY_RECOGNITION = "com.google.android.gms.permission.ACTIVITY_RECOGNITION";
    public static final PermissionChecker INSTANCE;

    @NotNull
    public final String getACCESS_NETWORK_STATE() {
        return ACCESS_NETWORK_STATE;
    }

    @NotNull
    public final String getREAD_PHONE_STATE() {
        return READ_PHONE_STATE;
    }

    @NotNull
    public final String getACCESS_COARSE_LOCATION() {
        return ACCESS_COARSE_LOCATION;
    }

    @NotNull
    public final String getACCESS_FINE_LOCATION() {
        return ACCESS_FINE_LOCATION;
    }

    @NotNull
    public final String getACCESS_WIFI_STATE() {
        return ACCESS_WIFI_STATE;
    }

    @NotNull
    public final String getGET_ACCOUNTS() {
        return GET_ACCOUNTS;
    }

    @NotNull
    public final String getACTIVITY_RECOGNITION() {
        return ACTIVITY_RECOGNITION;
    }

    public final boolean hasPermission(@NotNull Context context, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    public final boolean hasPermissions(@NotNull Context context, String ... permissions) {
        String[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        boolean allGranted = true;
        String[] stringArray = $receiver$iv = permissions;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl = false;
            if (INSTANCE.hasPermission(context, it)) continue;
            allGranted = false;
        }
        return allGranted;
    }

    public final void ifHasPermission(@NotNull Context context, @NotNull String permission, @NotNull Function0<Unit> toDo) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull(toDo, (String)"toDo");
        if (this.hasPermission(context, permission)) {
            toDo.invoke();
        }
    }

    private PermissionChecker() {
    }

    static {
        PermissionChecker permissionChecker;
        INSTANCE = permissionChecker = new PermissionChecker();
        ACCESS_NETWORK_STATE = ACCESS_NETWORK_STATE;
        READ_PHONE_STATE = READ_PHONE_STATE;
        ACCESS_COARSE_LOCATION = ACCESS_COARSE_LOCATION;
        ACCESS_FINE_LOCATION = ACCESS_FINE_LOCATION;
        ACCESS_WIFI_STATE = ACCESS_WIFI_STATE;
        GET_ACCOUNTS = GET_ACCOUNTS;
        ACTIVITY_RECOGNITION = ACTIVITY_RECOGNITION;
    }
}

