/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.a.d;
import io.reactivex.internal.a.e;
import io.reactivex.internal.a.h;
import io.reactivex.internal.f.o;
import io.reactivex.internal.i.g;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOSECONDS = TimeUnit.MINUTES.toNanos(Long.getLong("rx2.scheduler.drift-tolerance", 15L));

    public static long clockDriftTolerance() {
        return CLOCK_DRIFT_TOLERANCE_NANOSECONDS;
    }

    @NonNull
    public abstract Worker createWorker();

    public long now(@NonNull TimeUnit timeUnit) {
        return timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void shutdown() {
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable runnable) {
        return this.scheduleDirect(runnable, 0L, TimeUnit.NANOSECONDS);
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable runnable, long l2, @NonNull TimeUnit timeUnit) {
        Worker worker = this.createWorker();
        runnable = RxJavaPlugins.onSchedule(runnable);
        runnable = new a(runnable, worker);
        worker.schedule(runnable, l2, timeUnit);
        return runnable;
    }

    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable runnable, long l2, long l3, @NonNull TimeUnit timeUnit) {
        Worker worker = this.createWorker();
        runnable = RxJavaPlugins.onSchedule(runnable);
        Disposable disposable = worker.schedulePeriodically(runnable = new b(runnable, worker), l2, l3, timeUnit);
        if (disposable == e.a) {
            return disposable;
        }
        return runnable;
    }

    @NonNull
    public <S extends Scheduler> S when(@NonNull Function<Flowable<Flowable<Completable>>, Completable> function) {
        return (S)new o(function, this);
    }

    static final class a
    implements Disposable,
    Runnable {
        @NonNull
        private Runnable a;
        @NonNull
        private Worker b;
        @Nullable
        private Thread c;

        a(@NonNull Runnable runnable, @NonNull Worker worker) {
            this.a = runnable;
            this.b = worker;
        }

        @Override
        public final void run() {
            this.c = Thread.currentThread();
            try {
                this.a.run();
                return;
            }
            finally {
                this.dispose();
                this.c = null;
            }
        }

        @Override
        public final void dispose() {
            if (this.c == Thread.currentThread() && this.b instanceof io.reactivex.internal.f.h) {
                ((io.reactivex.internal.f.h)this.b).b();
                return;
            }
            this.b.dispose();
        }

        @Override
        public final boolean isDisposed() {
            return this.b.isDisposed();
        }
    }

    static final class b
    implements Disposable,
    Runnable {
        @NonNull
        private Runnable a;
        @NonNull
        private Worker b;
        private volatile boolean c;

        b(@NonNull Runnable runnable, @NonNull Worker worker) {
            this.a = runnable;
            this.b = worker;
        }

        @Override
        public final void run() {
            if (!this.c) {
                try {
                    this.a.run();
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Exceptions.throwIfFatal(throwable);
                    this.b.dispose();
                    throw g.a(throwable2);
                }
            }
        }

        @Override
        public final void dispose() {
            this.c = true;
            this.b.dispose();
        }

        @Override
        public final boolean isDisposed() {
            return this.c;
        }
    }

    public static abstract class Worker
    implements Disposable {
        @NonNull
        public Disposable schedule(@NonNull Runnable runnable) {
            return this.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
        }

        @NonNull
        public abstract Disposable schedule(@NonNull Runnable var1, long var2, @NonNull TimeUnit var4);

        @NonNull
        public Disposable schedulePeriodically(@NonNull Runnable object, long l2, long l3, @NonNull TimeUnit timeUnit) {
            h h2 = new h();
            h h3 = new h(h2);
            object = RxJavaPlugins.onSchedule((Runnable)object);
            long l4 = timeUnit.toNanos(l3);
            long l5 = this.now(TimeUnit.NANOSECONDS);
            long l6 = l5 + timeUnit.toNanos(l2);
            object = this.schedule(new a(this, l6, (Runnable)object, l5, h3, l4), l2, timeUnit);
            if (object == e.a) {
                return object;
            }
            Object object2 = object;
            object = h2;
            d.c((AtomicReference<Disposable>)object, (Disposable)object2);
            return h3;
        }

        public long now(@NonNull TimeUnit timeUnit) {
            return timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        final class a
        implements Runnable {
            @NonNull
            private Runnable a;
            @NonNull
            private h b;
            private long c;
            private long d;
            private long e;
            private long f;
            private /* synthetic */ Worker g;

            a(Worker worker, long l2, @NonNull Runnable runnable, long l3, @NonNull h h2, long l4) {
                this.g = worker;
                this.a = runnable;
                this.b = h2;
                this.c = l4;
                this.e = l3;
                this.f = l2;
            }

            @Override
            public final void run() {
                this.a.run();
                if (!this.b.isDisposed()) {
                    long l2;
                    long l3 = this.g.now(TimeUnit.NANOSECONDS);
                    if (l3 + CLOCK_DRIFT_TOLERANCE_NANOSECONDS < this.e || l3 >= this.e + this.c + CLOCK_DRIFT_TOLERANCE_NANOSECONDS) {
                        l2 = l3 + this.c;
                        this.f = l2 - this.c * ++this.d;
                    } else {
                        l2 = this.f + ++this.d * this.c;
                    }
                    this.e = l3;
                    long l4 = l2 - l3;
                    Disposable disposable = this.g.schedule(this, l4, TimeUnit.NANOSECONDS);
                    h h2 = this.b;
                    io.reactivex.internal.a.d.c(h2, disposable);
                }
            }
        }
    }
}

