/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.b;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class PublishSubject<T>
extends b<T> {
    static final a[] TERMINATED = new a[0];
    static final a[] EMPTY = new a[0];
    final AtomicReference<a<T>[]> subscribers = new AtomicReference<a[]>(EMPTY);
    Throwable error;

    @CheckReturnValue
    @NonNull
    public static <T> PublishSubject<T> create() {
        return new PublishSubject<T>();
    }

    PublishSubject() {
    }

    @Override
    protected final void subscribeActual(Observer<? super T> observer) {
        Serializable serializable = new a<T>(observer, this);
        observer.onSubscribe((Disposable)((Object)serializable));
        if (this.add((a<T>)serializable)) {
            if (serializable.isDisposed()) {
                this.remove((a<T>)serializable);
                return;
            }
        } else {
            serializable = this.error;
            if (serializable != null) {
                observer.onError((Throwable)serializable);
                return;
            }
            observer.onComplete();
        }
    }

    final boolean add(a<T> a2) {
        a[] aArray;
        a<T>[] aArray2;
        do {
            if ((aArray2 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = aArray2.length;
            aArray = new a[n2 + 1];
            System.arraycopy(aArray2, 0, aArray, 0, n2);
            aArray[n2] = a2;
        } while (!this.subscribers.compareAndSet(aArray2, aArray));
        return true;
    }

    final void remove(a<T> a2) {
        a[] aArray;
        a<T>[] aArray2;
        do {
            if ((aArray2 = this.subscribers.get()) == TERMINATED || aArray2 == EMPTY) {
                return;
            }
            int n2 = aArray2.length;
            int n3 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (aArray2[i2] != a2) continue;
                n3 = i2;
                break;
            }
            if (n3 < 0) {
                return;
            }
            if (n2 == 1) {
                aArray = EMPTY;
                continue;
            }
            aArray = new a[n2 - 1];
            System.arraycopy(aArray2, 0, aArray, 0, n3);
            System.arraycopy(aArray2, n3 + 1, aArray, n3, n2 - n3 - 1);
        } while (!this.subscribers.compareAndSet(aArray2, aArray));
    }

    @Override
    public final void onSubscribe(Disposable disposable) {
        if (this.subscribers.get() == TERMINATED) {
            disposable.dispose();
        }
    }

    @Override
    public final void onNext(T t2) {
        io.reactivex.internal.functions.a.a(t2, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        for (a<T> a2 : this.subscribers.get()) {
            a<T> a3 = a2;
            T t3 = t2;
            a3 = a2;
            if (a2.get()) continue;
            a3.a.onNext(t3);
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        io.reactivex.internal.functions.a.a(throwable, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(throwable);
            return;
        }
        this.error = throwable;
        for (a a2 : this.subscribers.getAndSet(TERMINATED)) {
            a a3;
            Throwable throwable2 = throwable;
            a2 = a2;
            if (a3.get()) {
                RxJavaPlugins.onError(throwable2);
                continue;
            }
            a2.a.onError(throwable2);
        }
    }

    @Override
    public final void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        for (a a2 : this.subscribers.getAndSet(TERMINATED)) {
            a a3 = a2;
            a3 = a2;
            if (a2.get()) continue;
            a3.a.onComplete();
        }
    }

    static final class a<T>
    extends AtomicBoolean
    implements Disposable {
        final Observer<? super T> a;
        private PublishSubject<T> b;

        a(Observer<? super T> observer, PublishSubject<T> publishSubject) {
            this.a = observer;
            this.b = publishSubject;
        }

        @Override
        public final void dispose() {
            if (this.compareAndSet(false, true)) {
                this.b.remove(this);
            }
        }

        @Override
        public final boolean isDisposed() {
            return this.get();
        }
    }
}

