/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.d.c.b;
import io.reactivex.internal.d.c.c;
import io.reactivex.internal.d.c.d;
import io.reactivex.internal.d.c.e;
import io.reactivex.internal.d.c.g;
import io.reactivex.internal.d.c.h;
import io.reactivex.internal.d.c.i;
import io.reactivex.internal.d.c.j;
import io.reactivex.internal.d.c.k;
import io.reactivex.internal.d.c.l;
import io.reactivex.internal.d.c.m;
import io.reactivex.internal.d.c.n;
import io.reactivex.internal.d.c.o;
import io.reactivex.internal.d.c.q;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.a;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class Maybe<T>
implements MaybeSource<T> {
    @CheckReturnValue
    @NonNull
    public static <T> Maybe<T> create(MaybeOnSubscribe<T> maybeOnSubscribe) {
        a.a(maybeOnSubscribe, "onSubscribe is null");
        return RxJavaPlugins.a(new c<T>(maybeOnSubscribe));
    }

    @CheckReturnValue
    @NonNull
    public static <T> Maybe<T> defer(Callable<? extends MaybeSource<? extends T>> callable) {
        a.a(callable, "maybeSupplier is null");
        return RxJavaPlugins.a(new d(callable));
    }

    @CheckReturnValue
    public static <T> Maybe<T> empty() {
        return RxJavaPlugins.a(e.a);
    }

    @CheckReturnValue
    @NonNull
    public static <T> Maybe<T> fromCallable(@NonNull Callable<? extends T> callable) {
        a.a(callable, "callable is null");
        return RxJavaPlugins.a(new h<T>(callable));
    }

    @CheckReturnValue
    @NonNull
    private static Maybe<Long> a(long l2, TimeUnit timeUnit, Scheduler scheduler) {
        a.a(timeUnit, "unit is null");
        a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.a(new o(Math.max(0L, l2), timeUnit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public final Maybe<T> doOnError(Consumer<? super Throwable> consumer) {
        Action action = Functions.EMPTY_ACTION;
        return RxJavaPlugins.a(new k(this, Functions.emptyConsumer(), Functions.emptyConsumer(), a.a(consumer, "onError is null"), action, action, Functions.EMPTY_ACTION));
    }

    @CheckReturnValue
    @NonNull
    public final Completable flatMapCompletable(Function<? super T, ? extends CompletableSource> function) {
        a.a(function, "mapper is null");
        return RxJavaPlugins.onAssembly(new g<T>(this, function));
    }

    @CheckReturnValue
    @NonNull
    public final Maybe<T> observeOn(Scheduler scheduler) {
        a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.a(new i(this, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public final Single<T> toSingle(T t2) {
        a.a(t2, "defaultValue is null");
        return RxJavaPlugins.onAssembly(new q<T>(this, t2));
    }

    @CheckReturnValue
    public final Maybe<T> onErrorComplete() {
        Predicate predicate = Functions.alwaysTrue();
        Maybe maybe = this;
        a.a(predicate, "predicate is null");
        return RxJavaPlugins.a(new j(maybe, predicate));
    }

    @CheckReturnValue
    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> consumer2) {
        return this.subscribe(consumer, consumer2, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @NonNull
    public final Disposable subscribe(Consumer<? super T> object, Consumer<? super Throwable> object2, Action action) {
        a.a(object, "onSuccess is null");
        a.a(object2, "onError is null");
        a.a(action, "onComplete is null");
        object2 = new b<T>(object, (Consumer<Throwable>)object2, action);
        object = this;
        ((Maybe)object).subscribe((MaybeObserver<? super T>)object2);
        return (Disposable)object2;
    }

    @Override
    public final void subscribe(MaybeObserver<? super T> object) {
        a.a(object, "observer is null");
        object = RxJavaPlugins.a(this, object);
        a.a(object, "The RxJavaPlugins.onSubscribe hook returned a null MaybeObserver. Please check the handler provided to RxJavaPlugins.setOnMaybeSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
        try {
            this.a((MaybeObserver<? super T>)object);
            return;
        }
        catch (NullPointerException nullPointerException) {
            object = nullPointerException;
            throw nullPointerException;
        }
        catch (Throwable throwable) {
            object = throwable;
            Exceptions.throwIfFatal(throwable);
            NullPointerException nullPointerException = new NullPointerException("subscribeActual failed");
            nullPointerException.initCause((Throwable)object);
            throw nullPointerException;
        }
    }

    protected abstract void a(MaybeObserver<? super T> var1);

    @CheckReturnValue
    @NonNull
    public final Maybe<T> subscribeOn(Scheduler scheduler) {
        a.a(scheduler, "scheduler is null");
        return RxJavaPlugins.a(new l(this, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public final Maybe<T> switchIfEmpty(MaybeSource<? extends T> maybeSource) {
        a.a(maybeSource, "other is null");
        return RxJavaPlugins.a(new m<T>(this, maybeSource));
    }

    @CheckReturnValue
    @NonNull
    public final Maybe<T> timeout(long l2, TimeUnit object, Scheduler scheduler, MaybeSource<? extends T> maybeSource) {
        a.a(maybeSource, "fallback is null");
        Maybe<Long> maybe = Maybe.a(l2, object, scheduler);
        object = maybeSource;
        Maybe<Long> maybe2 = maybe;
        Maybe maybe3 = this;
        a.a(maybe2, "timeoutIndicator is null");
        a.a(object, "fallback is null");
        return RxJavaPlugins.a(new n(maybe3, (MaybeSource<Long>)maybe2, object));
    }

    @CheckReturnValue
    public final Maybe<T> timeout(long l2, TimeUnit timeUnit, Scheduler scheduler) {
        Maybe<Long> maybe = Maybe.a(l2, timeUnit, scheduler);
        Maybe maybe2 = this;
        a.a(maybe, "timeoutIndicator is null");
        return RxJavaPlugins.a(new n(maybe2, maybe, null));
    }
}

