/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.datalytics.geofence;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.squareup.moshi.JsonAdapter;
import io.hengam.lib.datalytics.geofence.GeofenceException;
import io.hengam.lib.datalytics.geofence.GeofenceService;
import io.hengam.lib.datalytics.messages.downstream.GeofenceMessage;
import io.hengam.lib.datalytics.messages.downstream.GeofenceMessageJsonAdapter;
import io.hengam.lib.datalytics.tasks.GeofencePeriodicRegisterTask;
import io.hengam.lib.internal.HengamMoshi;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.internal.task.TaskOptions;
import io.hengam.lib.internal.task.TaskScheduler;
import io.hengam.lib.messaging.PostOffice;
import io.hengam.lib.utils.HengamStorage;
import io.hengam.lib.utils.PermissionChecker;
import io.hengam.lib.utils.PersistedMap;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.TimeUtils;
import io.hengam.lib.utils.log.Plog;
import io.hengam.lib.utils.rx.RxKotlinKt;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010 \u001a\u00020\u0016H\u0003J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020+J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/hengam/lib/datalytics/geofence/GeofenceManager;", "", "context", "Landroid/content/Context;", "postOffice", "Lio/hengam/lib/messaging/PostOffice;", "taskScheduler", "Lio/hengam/lib/internal/task/TaskScheduler;", "hengamStorage", "Lio/hengam/lib/utils/HengamStorage;", "hengamMoshi", "Lio/hengam/lib/internal/HengamMoshi;", "(Landroid/content/Context;Lio/hengam/lib/messaging/PostOffice;Lio/hengam/lib/internal/task/TaskScheduler;Lio/hengam/lib/utils/HengamStorage;Lio/hengam/lib/internal/HengamMoshi;)V", "geofenceTriggerCounts", "Lio/hengam/lib/utils/PersistedMap;", "", "getGeofenceTriggerCounts", "()Lio/hengam/lib/utils/PersistedMap;", "geofenceTriggerTimes", "Lio/hengam/lib/utils/Time;", "getGeofenceTriggerTimes", "geofences", "Lio/hengam/lib/datalytics/messages/downstream/GeofenceMessage;", "getGeofences", "geofencingClient", "Lcom/google/android/gms/location/GeofencingClient;", "getGeofencingClient", "()Lcom/google/android/gms/location/GeofencingClient;", "geofencingClient$delegate", "Lkotlin/Lazy;", "addOrUpdateGeofence", "", "geofence", "attemptAddingGeofence", "Lio/reactivex/Single;", "", "attemptRemovingGeofence", "Lio/reactivex/Completable;", "geofenceId", "", "ensureGeofencesAreRegistered", "onGeofenceTriggered", "removeGeofence", "Lio/hengam/lib/datalytics/messages/downstream/RemoveGeofenceMessage;", "datalytics_release"})
public final class a {
    static final /* synthetic */ KProperty[] a;
    @NotNull
    public final PersistedMap<GeofenceMessage> b;
    @NotNull
    public final PersistedMap<Integer> c;
    @NotNull
    public final PersistedMap<Time> d;
    private final Lazy f;
    private final Context g;
    final PostOffice e;
    private final TaskScheduler h;

    static {
        a = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(a.class), "geofencingClient", "getGeofencingClient()Lcom/google/android/gms/location/GeofencingClient;"))};
    }

    public final void a(final @NotNull GeofenceMessage geofenceMessage) {
        Time time;
        Time time2;
        Intrinsics.checkParameterIsNotNull((Object)geofenceMessage, (String)"geofence");
        Date date = geofenceMessage.f;
        Time time3 = date != null ? Long.valueOf(date.getTime() - TimeUtils.INSTANCE.nowMillis()) : null;
        if ((time3 != null ? time3.longValue() : 0L) < 0L) {
            Plog.INSTANCE.warn("Datalytics", "Geofence", "The expiration time for a received geofence request has already been reached, the geofence will not be registered", new Pair[0]);
            return;
        }
        Time time4 = this.b;
        String string = geofenceMessage.b;
        GeofenceMessage geofenceMessage2 = geofenceMessage;
        Time time5 = time3;
        if (time5 != null) {
            time2 = time5;
            GeofenceMessage geofenceMessage3 = geofenceMessage2;
            String string2 = string;
            time3 = time4;
            time2 = TimeKt.millis((long)((Number)time2).longValue());
            time4 = time3;
            string = string2;
            geofenceMessage2 = geofenceMessage3;
            time = time2;
        } else {
            time = null;
        }
        time4.put(string, (Object)geofenceMessage2, time);
        TaskScheduler.schedulePeriodicTask$default((TaskScheduler)this.h, (PeriodicTaskOptions)new GeofencePeriodicRegisterTask.a(), null, (int)2, null);
        Single<Boolean> single = this.b(geofenceMessage);
        time2 = io.hengam.lib.datalytics.geofence.a$b.a;
        geofenceMessage = (Function1)new Function1<Boolean, Unit>(){

            public final /* synthetic */ Object invoke(Object object) {
                boolean bl = (Boolean)object;
                object = this;
                if (bl) {
                    String string;
                    Pair[] pairArray = new Pair[7];
                    pairArray[0] = TuplesKt.to((Object)"Lat/Long", (Object)("" + object.geofenceMessage.c + '/' + object.geofenceMessage.d));
                    pairArray[1] = TuplesKt.to((Object)"Radius", (Object)Float.valueOf(object.geofenceMessage.e));
                    pairArray[2] = TuplesKt.to((Object)"Id", (Object)object.geofenceMessage.b);
                    switch (object.geofenceMessage.g) {
                        case 1: {
                            string = "enter";
                            break;
                        }
                        case 2: {
                            string = "exit";
                            break;
                        }
                        default: {
                            string = "unknown (" + object.geofenceMessage.g + ')';
                        }
                    }
                    pairArray[3] = TuplesKt.to((Object)"Trigger", (Object)string);
                    pairArray[4] = TuplesKt.to((Object)"Trigger on Init", (Object)object.geofenceMessage.h);
                    pairArray[5] = TuplesKt.to((Object)"Dwell Time", (Object)object.geofenceMessage.i);
                    pairArray[6] = TuplesKt.to((Object)"Limit", (Object)object.geofenceMessage.k);
                    Plog.INSTANCE.info("Datalytics", "Geofence", "Geofence successfully registered", pairArray);
                }
                return Unit.INSTANCE;
            }
        };
        RxKotlinKt.subscribeBy(single, (Function1)time2, (Function1)geofenceMessage);
    }

    public final void a(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"geofenceId");
        this.b.remove((Object)string);
        if (this.b.isEmpty()) {
            this.h.cancelTask((TaskOptions)new GeofencePeriodicRegisterTask.a());
        }
        RxKotlinKt.subscribeBy$default((Completable)this.b(string), (Function1)j.a, null, (int)2, null);
    }

    @NotNull
    public final Completable a() {
        if (this.b.isEmpty()) {
            Completable completable = Completable.complete();
            Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.complete()");
            return completable;
        }
        Plog.INSTANCE.debug("Datalytics", "Geofence", "Re-registering " + this.b.size() + " geofences", new Pair[0]);
        final Throwable throwable = new Throwable();
        Completable completable = Observable.fromIterable((Iterable)this.b.values()).flatMapSingle(new Function<T, SingleSource<? extends R>>(){

            public final /* synthetic */ Object apply(Object object) {
                GeofenceMessage geofenceMessage = (GeofenceMessage)object;
                object = this;
                Intrinsics.checkParameterIsNotNull((Object)geofenceMessage, (String)"geofence");
                return object.this.b(geofenceMessage).map(new Function<T, R>(object){
                    final /* synthetic */ f a;

                    public final /* synthetic */ Object apply(Object object) {
                        Boolean bl = (Boolean)object;
                        object = this;
                        Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                        return object.a.throwable;
                    }
                    {
                        this.a = f2;
                    }
                }).onErrorReturn((Function)2.a);
            }
        }).filter((Predicate)new Predicate<Throwable>(){

            public final /* synthetic */ boolean test(Object object) {
                Throwable throwable2 = (Throwable)object;
                object = this;
                Intrinsics.checkParameterIsNotNull((Object)throwable2, (String)"it");
                return Intrinsics.areEqual((Object)throwable2, (Object)object.throwable) ^ true;
            }
        }).toList().doOnSuccess((Consumer)new Consumer<List<Throwable>>(){

            public final /* synthetic */ void accept(Object object) {
                List list = (List)object;
                object = this;
                if (list.size() > 1) {
                    Plog.INSTANCE.warn("Datalytics", "Geofence", "Failed to reregister " + list.size() + " geofences", (Throwable)list.get(0), new Pair[0]);
                    return;
                }
                if (list.size() == 1) {
                    Plog.INSTANCE.warn("Datalytics", "Geofence", "Failed to reregister geofence", (Throwable)list.get(0), new Pair[0]);
                    return;
                }
                Plog.INSTANCE.trace("Datalytics", "Geofence", "Re-registering " + b.size() + " geofences successful", new Pair[0]);
            }
        }).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Observable.fromIterable(\u2026         .ignoreElement()");
        return completable;
    }

    @SuppressLint(value={"MissingPermission"})
    private final Single<Boolean> b(GeofenceMessage geofenceMessage) {
        if (!PermissionChecker.INSTANCE.hasPermission(this.g, "android.permission.ACCESS_FINE_LOCATION")) {
            Plog.INSTANCE.warn("Datalytics", "Geofence", "Unable to add geofence due to missing location permissions", new Pair[0]);
            Single single = Single.just((Object)Boolean.FALSE);
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(false)");
            return single;
        }
        try {
            GeofencingRequest.Builder builder;
            Geofence.Builder builder2;
            int n2;
            Date date = geofenceMessage.f;
            Long l2 = date != null ? Long.valueOf(date.getTime() - TimeUtils.INSTANCE.nowMillis()) : null;
            if ((l2 != null ? l2 : 0L) < 0L) {
                Plog.INSTANCE.warn("Datalytics", "Geofence", "Attempted to register expired geofence, geofence will be removed", new Pair[0]);
                this.a(geofenceMessage.b);
                Single single = Single.just((Object)Boolean.FALSE);
                Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(false)");
                return single;
            }
            if (geofenceMessage.g == 1 && (geofenceMessage.i == null || geofenceMessage.i.toMillis() <= 0L)) {
                n2 = 1;
            } else if (geofenceMessage.g == 1 && geofenceMessage.i != null) {
                n2 = 4;
            } else if (geofenceMessage.g == 2) {
                if (geofenceMessage.i != null && geofenceMessage.i.toMillis() > 0L) {
                    Plog.INSTANCE.warn("Datalytics", "Geofence", "Dwell times are not supported for geofences with `EXIT` triggers", new Pair[]{TuplesKt.to((Object)"Geofence", (Object)geofenceMessage)});
                }
                n2 = 2;
            } else {
                Plog.INSTANCE.warn("Datalytics", "Geofence", "Invalid trigger value received for geofence: " + geofenceMessage.g + ", using 'enter' trigger instead", new Pair[0]);
                n2 = 1;
            }
            int n3 = n2;
            Geofence.Builder builder3 = builder2 = new Geofence.Builder();
            builder2.setRequestId(geofenceMessage.b);
            builder3.setCircularRegion(geofenceMessage.c, geofenceMessage.d, geofenceMessage.e);
            Long l3 = l2;
            builder3.setExpirationDuration(l3 != null ? l3 : -1L);
            builder3.setTransitionTypes(n3);
            if (geofenceMessage.j != null && geofenceMessage.j.toMillis() >= 0L) {
                builder3.setNotificationResponsiveness((int)geofenceMessage.j.toMillis());
            }
            if (n3 == 4) {
                Time time = geofenceMessage.i;
                builder3.setLoiteringDelay(time != null ? (int)time.toMillis() : 0);
            }
            l2 = builder2.build();
            Boolean bl = geofenceMessage.h;
            boolean bl2 = bl != null ? bl : geofenceMessage.g == 1;
            GeofencingRequest.Builder builder4 = builder = new GeofencingRequest.Builder();
            if (bl2) {
                int n4;
                switch (n3) {
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n4 = 2;
                        break;
                    }
                    case 4: {
                        n4 = 5;
                        break;
                    }
                    default: {
                        n4 = 1;
                    }
                }
                builder4.setInitialTrigger(n4);
            } else {
                builder4.setInitialTrigger(0);
            }
            builder4.addGeofence((Geofence)l2);
            builder3 = builder.build();
            builder = new Intent(this.g, GeofenceService.class);
            builder4 = PendingIntent.getService((Context)this.g, (int)1043918, (Intent)builder, (int)0x8000000);
            Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>((GeofencingRequest)builder3, (PendingIntent)builder4, geofenceMessage){
                final /* synthetic */ GeofencingRequest b;
                final /* synthetic */ PendingIntent c;
                final /* synthetic */ GeofenceMessage d;

                /*
                 * WARNING - void declaration
                 */
                public final void subscribe(@NotNull SingleEmitter<Boolean> emitter) {
                    Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                    Task task = io.hengam.lib.datalytics.geofence.a.a(this).addGeofences(this.b, this.c);
                    if (task != null) {
                        void var1_1;
                        Task task2 = task;
                        task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(this, emitter){
                            final /* synthetic */ c a;
                            final /* synthetic */ SingleEmitter b;
                            {
                                this.a = c2;
                                this.b = singleEmitter;
                            }
                        });
                        task2.addOnFailureListener(new OnFailureListener(this, (SingleEmitter)var1_1){
                            final /* synthetic */ c a;
                            final /* synthetic */ SingleEmitter b;
                            {
                                this.a = c2;
                                this.b = singleEmitter;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void onFailure(@NotNull Exception ex) {
                                void var1_1;
                                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                                this.b.tryOnError((Throwable)new GeofenceException("Adding or updating geofence failed", (Throwable)var1_1, this.a.d));
                            }
                        });
                        return;
                    }
                }
                {
                    this.b = geofencingRequest;
                    this.c = pendingIntent;
                    this.d = geofenceMessage;
                }
            }).subscribeOn(SchedulersKt.cpuThread()).observeOn(SchedulersKt.cpuThread());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<Boolean> {\u2026)).observeOn(cpuThread())");
            return single;
        }
        catch (Exception exception) {
            Single single = Single.fromCallable((Callable)new Callable<T>(){});
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromCallable { throw ex }");
            return single;
        }
    }

    private final Completable b(final String string) {
        try {
            Completable completable = Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

                /*
                 * WARNING - void declaration
                 */
                public final void subscribe(@NotNull CompletableEmitter emitter) {
                    Intrinsics.checkParameterIsNotNull((Object)emitter, (String)"emitter");
                    Task task = io.hengam.lib.datalytics.geofence.a.a(this).removeGeofences(CollectionsKt.listOf((Object)string));
                    if (task != null) {
                        void var1_1;
                        Task task2 = task;
                        task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(this, emitter){
                            final /* synthetic */ e a;
                            final /* synthetic */ CompletableEmitter b;
                            {
                                this.a = e2;
                                this.b = completableEmitter;
                            }

                            public final /* synthetic */ void onSuccess(Object object) {
                                object = this;
                                Plog.INSTANCE.info("Datalytics", "Geofence", "Geofence has been unregistered", new Pair[]{TuplesKt.to((Object)"Id", (Object)object.a.string)});
                                object.b.onComplete();
                            }
                        });
                        task2.addOnFailureListener(new OnFailureListener(this, (CompletableEmitter)var1_1){
                            final /* synthetic */ e a;
                            final /* synthetic */ CompletableEmitter b;
                            {
                                this.a = e2;
                                this.b = completableEmitter;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void onFailure(@NotNull Exception ex) {
                                void var1_1;
                                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                                this.b.tryOnError((Throwable)new GeofenceException("Removing geofence failed", (Throwable)var1_1, 4));
                            }
                        });
                        return;
                    }
                }
            }).subscribeOn(SchedulersKt.cpuThread()).observeOn(SchedulersKt.cpuThread());
            Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.create { emi\u2026)).observeOn(cpuThread())");
            string = completable;
        }
        catch (Exception exception) {
            Completable completable = Completable.error((Throwable)new GeofenceException("Error occurred while removing geofence", (Throwable)exception, 4));
            Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.error(Geofen\u2026 removing geofence\", ex))");
            string = completable;
        }
        return string;
    }

    @Inject
    public a(@NotNull Context context, @NotNull PostOffice postOffice, @NotNull TaskScheduler taskScheduler, @NotNull HengamStorage hengamStorage, @NotNull HengamMoshi hengamMoshi) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)postOffice, (String)"postOffice");
        Intrinsics.checkParameterIsNotNull((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkParameterIsNotNull((Object)hengamStorage, (String)"hengamStorage");
        Intrinsics.checkParameterIsNotNull((Object)hengamMoshi, (String)"hengamMoshi");
        this.g = context;
        this.e = postOffice;
        this.h = taskScheduler;
        this.b = HengamStorage.createStoredMap$default((HengamStorage)hengamStorage, (String)"geofences", GeofenceMessage.class, (JsonAdapter)new GeofenceMessageJsonAdapter(hengamMoshi.getMoshi()), null, (int)8, null);
        this.c = HengamStorage.createStoredMap$default((HengamStorage)hengamStorage, (String)"geofence_counts", Integer.class, null, (int)4, null);
        this.d = HengamStorage.createStoredMap$default((HengamStorage)hengamStorage, (String)"geofence_times", Time.class, null, (int)4, null);
        this.f = LazyKt.lazy((Function0)((Function0)new Function0<GeofencingClient>(){

            public final /* synthetic */ Object invoke() {
                return LocationServices.getGeofencingClient((Context)g);
            }
        }));
    }

    public static final /* synthetic */ GeofencingClient a(a a2) {
        return (GeofencingClient)a2.f.getValue();
    }
}

